/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.http;

import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.internal.http.HttpConnection;
import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.C8DBRedirectException;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.util.HostUtils;
import com.c8db.internal.util.RequestUtils;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommunication
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommunication.class);
    private final Map<Service, HostHandler> hostHandlerMatrix;
    private AtomicInteger c = new AtomicInteger(0);

    private HttpCommunication(Map<Service, HostHandler> hostHandlerMatrix) {
        this.hostHandlerMatrix = hostHandlerMatrix;
    }

    @Override
    public void close() throws IOException {
        for (HostHandler hostHandler : this.hostHandlerMatrix.values()) {
            hostHandler.close();
        }
    }

    public Response execute(Request request, HostHandle hostHandle, Service service) throws C8DBException, IOException {
        AccessType accessType = RequestUtils.determineAccessType(request);
        HostHandler hostHandler = this.hostHandlerMatrix.get((Object)service);
        Host host = hostHandler.get(hostHandle, accessType);
        try {
            while (true) {
                try {
                    HttpConnection connection = (HttpConnection)host.connection();
                    Response response = connection.execute(request);
                    hostHandler.success();
                    hostHandler.confirm();
                    return response;
                }
                catch (SocketException se) {
                    hostHandler.fail();
                    if (hostHandle != null && hostHandle.getHost() != null) {
                        hostHandle.setHost(null);
                    }
                    Host failedHost = host;
                    host = hostHandler.get(hostHandle, accessType);
                    if (host != null) {
                        LOGGER.warn(String.format("Could not connect to %s. Try connecting to %s", failedHost.getDescription(), host.getDescription()));
                        continue;
                    }
                    throw se;
                }
                break;
            }
        }
        catch (C8DBException e) {
            if (e instanceof C8DBRedirectException) {
                String location = ((C8DBRedirectException)C8DBRedirectException.class.cast(e)).getLocation();
                HostDescription redirectHost = HostUtils.createFromLocation(location);
                hostHandler.closeCurrentOnError();
                hostHandler.fail();
                return this.execute(request, new HostHandle().setHost(redirectHost), service);
            }
            throw e;
        }
    }

    public static class Builder {
        private final Map<Service, HostHandler> hostHandlerMatrix;

        public Builder(Map<Service, HostHandler> hostHandlerMatrix) {
            this.hostHandlerMatrix = hostHandlerMatrix;
        }

        public Builder(Builder builder) {
            this(builder.hostHandlerMatrix);
        }

        public HttpCommunication build(C8Serialization util) {
            return new HttpCommunication(this.hostHandlerMatrix);
        }
    }
}

