/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.http;

import com.arangodb.velocypack.VPackSlice;
import com.c8db.C8DBException;
import com.c8db.Protocol;
import com.c8db.Service;
import com.c8db.internal.http.HttpDeleteWithBody;
import com.c8db.internal.http.HttpRequestRetryHandler;
import com.c8db.internal.net.Connection;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.util.CURLLogger;
import com.c8db.internal.util.IOUtils;
import com.c8db.internal.util.ResponseUtils;
import com.c8db.util.C8Serialization;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private static final ContentType CONTENT_TYPE_APPLICATION_JSON_UTF8 = ContentType.create((String)"application/json", (String)"utf-8");
    private static final ContentType CONTENT_TYPE_VPACK = ContentType.create((String)"application/x-velocypack");
    private static final int INITIAL_SLEEP_TIME_SEC = 4;
    private static final int SLEEP_TIME_MULTIPLIER = 2;
    private static final int MAX_SLEEP_TIME_SEC = 128;
    private final PoolingHttpClientConnectionManager cm;
    private final CloseableHttpClient client;
    private final Integer responseSizeLimit;
    private final String user;
    private final String password;
    private final String email;
    private final Boolean jwtAuthEnabled;
    private final C8Serialization util;
    private final Boolean useSsl;
    private final Protocol contentType;
    private final HostDescription host;
    private volatile String jwt;
    private volatile String defaultJWT;
    private final String apiKey;
    private final HostDescription auxHost;
    private final Service service;

    private HttpConnection(HostDescription host, Integer timeout, Integer responseSizeLimit, String user, String password, String email, Boolean jwtAuthEnabled, Boolean useSsl, SSLContext sslContext, C8Serialization util, Protocol contentType, Long ttl, String httpCookieSpec, String jwt, String apiKey, HostDescription auxHost, Service service) {
        this.host = host;
        this.responseSizeLimit = responseSizeLimit;
        this.user = user;
        this.password = password;
        this.email = email;
        this.jwtAuthEnabled = jwtAuthEnabled;
        this.useSsl = useSsl;
        this.util = util;
        this.contentType = contentType;
        this.defaultJWT = jwt;
        this.apiKey = apiKey;
        this.auxHost = auxHost;
        this.service = service;
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (Boolean.TRUE == useSsl) {
            if (sslContext != null) {
                registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext));
            } else {
                registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault()));
            }
        } else {
            registryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        }
        MessageConstraints messageConstraints = MessageConstraints.custom().setMaxLineLength(responseSizeLimit.intValue()).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
        this.cm = new PoolingHttpClientConnectionManager(registryBuilder.build());
        this.cm.setDefaultConnectionConfig(connectionConfig);
        this.cm.setDefaultMaxPerRoute(1);
        this.cm.setMaxTotal(1);
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (timeout != null && timeout >= 0) {
            requestConfig.setConnectTimeout(timeout.intValue());
            requestConfig.setConnectionRequestTimeout(timeout.intValue());
            requestConfig.setSocketTimeout(timeout.intValue());
        }
        if (httpCookieSpec != null && httpCookieSpec.length() > 1) {
            requestConfig.setCookieSpec(httpCookieSpec);
        }
        ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return HttpConnection.this.getKeepAliveDuration(response);
            }
        };
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig.build()).setConnectionManager((HttpClientConnectionManager)this.cm).setKeepAliveStrategy(keepAliveStrategy).setRetryHandler((org.apache.http.client.HttpRequestRetryHandler)new HttpRequestRetryHandler());
        if (ttl != null) {
            builder.setConnectionTimeToLive(ttl.longValue(), TimeUnit.MILLISECONDS);
        }
        this.client = builder.build();
    }

    private static String buildUrl(String baseUrl, Request request, Service service) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder().append(baseUrl);
        String database = request.getDatabase();
        String tenant = request.getTenant();
        if (tenant != null && !tenant.isEmpty() && service != Service.C8FUNCTION) {
            sb.append("/_tenant/").append(tenant);
        }
        if (database != null && !database.isEmpty()) {
            sb.append("/_fabric/").append(database);
        }
        sb.append(request.getRequest());
        if (!request.getQueryParam().isEmpty()) {
            if (request.getRequest().contains("?")) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            String paramString = URLEncodedUtils.format(HttpConnection.toList(request.getQueryParam()), (String)"utf-8");
            sb.append(paramString);
        }
        return sb.toString();
    }

    private static List<NameValuePair> toList(Map<String, String> parameters) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            if (param.getValue() == null) continue;
            paramList.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        return paramList;
    }

    private static void addHeader(Request request, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> header : request.getHeaderParam().entrySet()) {
            httpRequest.addHeader(header.getKey(), header.getValue());
        }
    }

    private long getKeepAliveDuration(HttpResponse response) {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 30000L;
    }

    @Override
    public void close() throws IOException {
        this.cm.shutdown();
        this.client.close();
    }

    public Response execute(Request request) throws C8DBException, IOException {
        String url = HttpConnection.buildUrl(this.buildBaseUrl(this.host), request, this.service);
        HttpRequestBase httpRequest = this.buildHttpRequestBase(request, url);
        httpRequest.setHeader("User-Agent", "Mozilla/5.0 (compatible; C8DB-JavaDriver/1.1; +http://mt.orz.at/)");
        if (this.contentType == Protocol.HTTP_VPACK) {
            httpRequest.setHeader("Accept", "application/x-velocypack");
        }
        httpRequest.setHeader("x-gdn-tenantid", request.getTenant());
        if (StringUtils.isNotEmpty((CharSequence)System.getenv("C8_SVCUSER"))) {
            httpRequest.setHeader("x-c8-requester", "internalRequest");
        }
        HttpConnection.addHeader(request, httpRequest);
        if (this.jwtAuthEnabled.booleanValue()) {
            this.updateJWT();
            if (StringUtils.isNotEmpty((CharSequence)this.apiKey) && this.jwt == null) {
                LOGGER.debug("Using API Key for authenication.");
                httpRequest.addHeader("Authorization", "apikey " + this.apiKey);
            } else if (this.jwt == null) {
                this.addJWT(request);
                LOGGER.debug("Using JWT for authentication.");
                httpRequest.addHeader("Authorization", "bearer " + this.jwt);
            } else {
                LOGGER.debug("Using JWT for authentication.");
                httpRequest.addHeader("Authorization", "bearer " + this.jwt);
            }
        } else {
            LOGGER.debug("Using Credentials for authenication.");
            Credentials credentials = this.addCredentials(httpRequest);
            if (LOGGER.isDebugEnabled()) {
                CURLLogger.log(url, request, credentials, this.util);
            }
        }
        Response response = null;
        try {
            response = this.buildResponse(this.client.execute((HttpUriRequest)httpRequest));
            this.checkError(response);
        }
        catch (C8DBException ex) {
            if (ex.getResponseCode().equals(401)) {
                this.addJWT(request);
                httpRequest.removeHeaders("Authorization");
                httpRequest.addHeader("Authorization", "bearer " + this.jwt);
                response = this.buildResponse(this.client.execute((HttpUriRequest)httpRequest));
                this.checkError(response);
            } else if (ex.getResponseCode() >= 500) {
                if (request.isRetryEnabled()) {
                    response = this.retryRequest(request, httpRequest);
                }
                this.checkError(response);
            } else if (ex.getResponseCode() >= 400) {
                this.checkError(response);
            } else {
                this.checkError(response);
            }
        }
        catch (UnknownHostException | NoHttpResponseException ex) {
            response = this.retryRequest(request, httpRequest);
        }
        return response;
    }

    private Response retryRequest(Request request, HttpRequestBase httpRequest) throws IOException {
        Response response = null;
        for (int currentWaitTime = 4; currentWaitTime <= 128; currentWaitTime *= 2) {
            try {
                LOGGER.info(String.format("Retrying request to %s in %d seconds...", this.service.name(), currentWaitTime));
                Thread.sleep(currentWaitTime * 1000);
                response = this.buildResponse(this.client.execute((HttpUriRequest)httpRequest));
                this.checkError(response);
                return response;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof C8DBException) || !((C8DBException)e).getResponseCode().equals(401)) continue;
                this.addJWT(request);
                httpRequest.removeHeaders("Authorization");
                httpRequest.addHeader("Authorization", "bearer " + this.jwt);
            }
        }
        LOGGER.info(String.format("Unable to connect to the C8DB after %d seconds. No more retries will be made", 128));
        return response;
    }

    private void updateJWT() {
        this.jwt = StringUtils.isNotEmpty((CharSequence)this.user) && !this.host.getHost().equals(this.auxHost.getHost()) ? null : this.defaultJWT;
    }

    private synchronized void addJWT(Request request) throws IOException {
        this.addServiceJWT();
        if (StringUtils.isNotEmpty((CharSequence)this.user) && !this.host.getHost().equals(this.auxHost.getHost()) && this.service != Service.C8FUNCTION) {
            this.addUserJWT(request.getTenant(), this.user);
        }
    }

    private synchronized void addServiceJWT() throws IOException {
        String authUrl = this.buildBaseUrl(this.auxHost) + "/_open/auth/internal";
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", this.user);
        credentials.put("password", this.password);
        credentials.put("email", this.email);
        HttpRequestBase authHttpRequest = this.buildHttpRequestBase(new Request("_mm", "_system", RequestType.POST, authUrl).setBody(this.util.serialize(credentials)), authUrl);
        authHttpRequest.setHeader("User-Agent", "Mozilla/5.0 (compatible; C8DB-JavaDriver/1.1; +http://mt.orz.at/)");
        if (this.contentType == Protocol.HTTP_VPACK) {
            authHttpRequest.setHeader("Accept", "application/x-velocypack");
        }
        Response authResponse = this.buildResponse(this.client.execute((HttpUriRequest)authHttpRequest));
        this.checkError(authResponse);
        this.defaultJWT = authResponse.getBody().get("jwt").getAsString();
        this.setJwt(this.defaultJWT);
    }

    private synchronized void addUserJWT(String tenant, String user) throws IOException {
        String authUrl = this.buildBaseUrl(this.host) + "/_tenant/" + tenant + "/_fabric/" + "_system" + "/_api/streams/user/" + user + "/jwt";
        HttpRequestBase authHttpRequest = this.buildHttpRequestBase(new Request(tenant, "_system", RequestType.POST, authUrl), authUrl);
        authHttpRequest.setHeader("User-Agent", "Mozilla/5.0 (compatible; C8DB-JavaDriver/1.1; +http://mt.orz.at/)");
        authHttpRequest.setHeader("Authorization", "bearer " + this.jwt);
        if (this.contentType == Protocol.HTTP_VPACK) {
            authHttpRequest.setHeader("Accept", "application/x-velocypack");
        }
        Response authResponse = this.buildResponse(this.client.execute((HttpUriRequest)authHttpRequest));
        this.checkError(authResponse);
        this.setJwt(authResponse.getBody().get("result").getAsString());
    }

    private HttpRequestBase buildHttpRequestBase(Request request, String url) {
        HttpHead httpRequest;
        switch (request.getRequestType()) {
            case POST: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), request);
                break;
            }
            case PUT: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPut(url), request);
                break;
            }
            case PATCH: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPatch(url), request);
                break;
            }
            case DELETE: {
                httpRequest = this.requestWithBody(new HttpDeleteWithBody(url), request);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(url);
                break;
            }
            default: {
                httpRequest = new HttpGet(url);
            }
        }
        return httpRequest;
    }

    private HttpRequestBase requestWithBody(HttpEntityEnclosingRequestBase httpRequest, Request request) {
        VPackSlice body = request.getBody();
        if (body != null) {
            if (this.contentType == Protocol.HTTP_VPACK) {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(Arrays.copyOfRange(body.getBuffer(), body.getStart(), body.getStart() + body.getByteSize()), CONTENT_TYPE_VPACK));
            } else {
                httpRequest.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_APPLICATION_JSON_UTF8));
            }
        }
        return httpRequest;
    }

    private String buildBaseUrl(HostDescription host) {
        return (Boolean.TRUE == this.useSsl ? "https://" : "http://") + host.getHost() + ":" + host.getPort();
    }

    public Credentials addCredentials(HttpRequestBase httpRequest) {
        UsernamePasswordCredentials credentials = null;
        if (this.user != null) {
            credentials = new UsernamePasswordCredentials(this.user, this.password != null ? this.password : "");
            try {
                httpRequest.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)httpRequest, null));
            }
            catch (AuthenticationException e) {
                throw new C8DBException(e);
            }
        }
        return credentials;
    }

    public Response buildResponse(CloseableHttpResponse httpResponse) throws UnsupportedOperationException, IOException {
        Response response;
        block8: {
            response = new Response();
            response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null && entity.getContent() != null) {
                Object content;
                if (this.contentType == Protocol.HTTP_VPACK) {
                    content = IOUtils.toByteArray(entity.getContent());
                    if (((byte[])content).length > 0) {
                        response.setBody(new VPackSlice(content));
                    }
                } else {
                    content = IOUtils.toString(entity.getContent());
                    if (!content.isEmpty()) {
                        try {
                            response.setBody(this.util.serialize(content, new C8Serializer.Options().stringAsJson(true).serializeNullValues(true)));
                        }
                        catch (C8DBException e) {
                            byte[] contentAsByteArray = content.getBytes();
                            if (contentAsByteArray.length <= 0) break block8;
                            response.setBody(new VPackSlice(contentAsByteArray));
                        }
                    }
                }
            }
        }
        Header[] headers = httpResponse.getAllHeaders();
        Map<String, String> meta = response.getMeta();
        for (Header header : headers) {
            meta.put(header.getName(), header.getValue());
        }
        return response;
    }

    protected void checkError(Response response) throws C8DBException {
        ResponseUtils.checkError(this.util, response);
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public static class Builder {
        private String user;
        private String password;
        private String email;
        private Boolean jwtAuthEnabled;
        private C8Serialization util;
        private Boolean useSsl;
        private String httpCookieSpec;
        private Protocol contentType;
        private HostDescription host;
        private Long ttl;
        private SSLContext sslContext;
        private Integer responseSizeLimit;
        private Integer timeout;
        private String jwt;
        private String apiKey;
        private HostDescription auxHost;
        private Service service;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder jwt(String jwt) {
            this.jwt = jwt;
            return this;
        }

        public Builder auxHost(HostDescription auxHost) {
            this.auxHost = auxHost;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder serializationUtil(C8Serialization util) {
            this.util = util;
            return this;
        }

        public Builder jwtAuthEnabled(Boolean jwtAuth) {
            this.jwtAuthEnabled = jwtAuth;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder httpCookieSpec(String httpCookieSpec) {
            this.httpCookieSpec = httpCookieSpec;
            return this;
        }

        public Builder contentType(Protocol contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder host(HostDescription host) {
            this.host = host;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder responseSizeLimit(Integer responseSizeLimit) {
            this.responseSizeLimit = responseSizeLimit;
            return this;
        }

        public Builder service(Service service) {
            this.service = service;
            return this;
        }

        public HttpConnection build() {
            return new HttpConnection(this.host, this.timeout, this.responseSizeLimit, this.user, this.password, this.email, this.jwtAuthEnabled, this.useSsl, this.sslContext, this.util, this.contentType, this.ttl, this.httpCookieSpec, this.jwt, this.apiKey, this.auxHost, this.service);
        }
    }
}

