/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.Service;
import com.c8db.internal.net.Connection;
import com.c8db.internal.net.ConnectionFactory;
import com.c8db.internal.net.ConnectionPool;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.velocystream.internal.VstConnection;
import com.c8db.internal.velocystream.internal.VstConnectionSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolImpl
implements ConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPoolImpl.class);
    private final HostDescription host;
    private final int maxConnections;
    private final List<Connection> connections;
    private int current;
    private final ConnectionFactory factory;
    private final Service service;

    public ConnectionPoolImpl(HostDescription host, Integer maxConnections, ConnectionFactory factory, Service service) {
        this.host = host;
        this.maxConnections = maxConnections;
        this.factory = factory;
        this.service = service;
        this.connections = new ArrayList<Connection>();
        this.current = 0;
    }

    @Override
    public Connection createConnection(HostDescription host) {
        return this.factory.create(host, this.service);
    }

    @Override
    public synchronized Connection connection() {
        Connection connection;
        if (this.connections.size() < this.maxConnections) {
            connection = this.createConnection(this.host);
            this.connections.add(connection);
            ++this.current;
        } else {
            int index = this.current++ % this.connections.size();
            connection = this.connections.get(index);
        }
        if (connection instanceof VstConnectionSync) {
            LOGGER.debug("Return Connection " + ((VstConnection)connection).getConnectionName());
        }
        return connection;
    }

    @Override
    public void close() throws IOException {
        for (Connection connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
    }

    public String toString() {
        return "ConnectionPoolImpl [host=" + this.host + ", maxConnections=" + this.maxConnections + ", connections=" + this.connections.size() + ", current=" + this.current + ", factory=" + this.factory.getClass().getSimpleName() + "]";
    }
}

