/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import java.io.IOException;

public class DirtyReadHostHandler
implements HostHandler {
    private final HostHandler master;
    private final HostHandler follower;
    private AccessType currentAccessType;

    public DirtyReadHostHandler(HostHandler master, HostHandler follower) {
        this.master = master;
        this.follower = follower;
    }

    private HostHandler determineHostHandler() {
        switch (this.currentAccessType) {
            case DIRTY_READ: {
                return this.follower;
            }
        }
        return this.master;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        this.currentAccessType = accessType;
        return this.determineHostHandler().get(hostHandle, accessType);
    }

    @Override
    public void success() {
        this.determineHostHandler().success();
    }

    @Override
    public void fail() {
        this.determineHostHandler().fail();
    }

    @Override
    public void reset() {
        this.determineHostHandler().reset();
    }

    @Override
    public void confirm() {
        this.determineHostHandler().confirm();
    }

    @Override
    public void close() throws IOException {
        this.master.close();
        this.follower.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.determineHostHandler().closeCurrentOnError();
    }
}

