/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.internal.C8Executor;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.net.ConnectionFactory;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.net.HostSet;
import com.c8db.internal.util.HostUtils;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHostResolver
implements HostResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedHostResolver.class);
    private Map<Service, HostSet> hostMatrix;
    private final Integer maxConnections;
    private final ConnectionFactory connectionFactory;
    private long lastUpdate;
    private Integer acquireHostListInterval;
    private C8ExecutorSync executor;
    private C8Serialization arangoSerialization;

    public ExtendedHostResolver(Map<Service, List<Host>> hostMatrix, Integer maxConnections, ConnectionFactory connectionFactory, Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
        this.hostMatrix = this.toHostSetsMap(hostMatrix);
        this.maxConnections = maxConnections;
        this.connectionFactory = connectionFactory;
        this.lastUpdate = 0L;
    }

    private Map<Service, HostSet> toHostSetsMap(Map<Service, List<Host>> hostMatrix) {
        HashMap<Service, HostSet> map = new HashMap<Service, HostSet>();
        for (Service key : hostMatrix.keySet()) {
            map.put(key, new HostSet(hostMatrix.get((Object)key)));
        }
        return map;
    }

    @Override
    public void init(C8ExecutorSync executor, C8Serialization arangoSerialization) {
        this.executor = executor;
        this.arangoSerialization = arangoSerialization;
    }

    @Override
    public HostSet resolve(Service service, boolean initial, boolean closeConnections) {
        HostSet hosts;
        if (!initial && this.isExpired()) {
            hosts = this.hostMatrix.get((Object)Service.C8DB);
            this.lastUpdate = System.currentTimeMillis();
            Collection<String> endpoints = this.resolveFromServer();
            LOGGER.debug("Resolve " + endpoints.size() + " Endpoints");
            LOGGER.debug("Endpoints " + Arrays.deepToString(endpoints.toArray()));
            if (!endpoints.isEmpty()) {
                hosts.markAllForDeletion();
            }
            for (String endpoint : endpoints) {
                LOGGER.debug("Create HOST from " + endpoint);
                if (endpoint.matches(".*://.+:[0-9]+")) {
                    HostDescription description;
                    String[] s = endpoint.replaceAll(".*://", "").split(":");
                    if (s.length == 2) {
                        description = new HostDescription(s[0], Integer.valueOf(s[1]));
                        hosts.addHost(HostUtils.createHost(description, this.maxConnections, this.connectionFactory, service));
                        continue;
                    }
                    if (s.length == 4) {
                        description = new HostDescription("127.0.0.1", Integer.valueOf(s[3]));
                        hosts.addHost(HostUtils.createHost(description, this.maxConnections, this.connectionFactory, service));
                        continue;
                    }
                    LOGGER.warn("Skip Endpoint (Missing Port)" + endpoint);
                    continue;
                }
                LOGGER.warn("Skip Endpoint (Format)" + endpoint);
            }
            try {
                hosts.clearAllMarkedForDeletion();
            }
            catch (IOException e) {
                LOGGER.error("Cant close all Hosts with MarkedForDeletion", (Throwable)e);
            }
        }
        hosts = this.hostMatrix.get((Object)service);
        return hosts;
    }

    private Collection<String> resolveFromServer() throws C8DBException {
        Collection<String> response;
        try {
            response = this.executor.execute(new Request("demo", "_system", RequestType.GET, "/_api/cluster/endpoints"), new C8Executor.ResponseDeserializer<Collection<String>>(){

                @Override
                public Collection<String> deserialize(Response response) throws VPackException {
                    List<String> endpoints;
                    VPackSlice field = response.getBody().get("endpoints");
                    if (field.isNone()) {
                        endpoints = Collections.emptyList();
                    } else {
                        Collection tmp = (Collection)ExtendedHostResolver.this.arangoSerialization.deserialize(field, (Type)((Object)Collection.class));
                        endpoints = new ArrayList<String>();
                        for (Map map : tmp) {
                            for (String value : map.values()) {
                                endpoints.add(value);
                            }
                        }
                    }
                    return endpoints;
                }
            }, null);
        }
        catch (C8DBException e) {
            Integer responseCode = e.getResponseCode();
            if (responseCode != null && responseCode == 403) {
                response = Collections.emptyList();
            }
            throw e;
        }
        return response;
    }

    private boolean isExpired() {
        return System.currentTimeMillis() > this.lastUpdate + (long)this.acquireHostListInterval.intValue();
    }
}

