/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.net.HostSet;
import java.io.IOException;
import java.util.List;

public class FallbackHostHandler
implements HostHandler {
    private Host current;
    private Host lastSuccess;
    private int iterations;
    private final HostResolver resolver;
    private final Service service;
    private boolean firstOpened;

    public FallbackHostHandler(HostResolver resolver, Service service) {
        this.resolver = resolver;
        this.service = service;
        this.iterations = 0;
        this.current = this.lastSuccess = resolver.resolve(service, true, false).getHostsList().get(0);
        this.firstOpened = true;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current != this.lastSuccess || this.iterations < 3) {
            return this.current;
        }
        this.reset();
        throw new C8DBException("Cannot contact any host!");
    }

    @Override
    public void success() {
        this.lastSuccess = this.current;
    }

    @Override
    public void fail() {
        List<Host> hosts = this.resolver.resolve(this.service, false, false).getHostsList();
        int index = hosts.indexOf(this.current) + 1;
        boolean inBound = index < hosts.size();
        this.current = hosts.get(inBound ? index : 0);
        if (!inBound) {
            ++this.iterations;
        }
    }

    @Override
    public void reset() {
        this.iterations = 0;
    }

    @Override
    public void confirm() {
        if (this.firstOpened) {
            this.resolver.resolve(this.service, false, false);
            this.firstOpened = false;
        }
    }

    @Override
    public void close() throws IOException {
        HostSet hosts = this.resolver.resolve(this.service, false, false);
        hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }
}

