/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.C8DBException;
import com.c8db.internal.net.Connection;
import com.c8db.internal.net.ConnectionPool;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import java.io.IOException;

public class HostImpl
implements Host {
    private final ConnectionPool connectionPool;
    private final HostDescription description;
    private boolean markforDeletion = false;

    public HostImpl(ConnectionPool connectionPool, HostDescription description) {
        this.connectionPool = connectionPool;
        this.description = description;
    }

    @Override
    public void close() throws IOException {
        this.connectionPool.close();
    }

    @Override
    public HostDescription getDescription() {
        return this.description;
    }

    @Override
    public Connection connection() {
        return this.connectionPool.connection();
    }

    @Override
    public void closeOnError() {
        try {
            this.connectionPool.close();
        }
        catch (IOException e) {
            throw new C8DBException(e);
        }
    }

    public String toString() {
        return "HostImpl [connectionPool=" + this.connectionPool + ", description=" + this.description + ", markforDeletion=" + this.markforDeletion + "]";
    }

    @Override
    public boolean isMarkforDeletion() {
        return this.markforDeletion;
    }

    @Override
    public void setMarkforDeletion(boolean markforDeletion) {
        this.markforDeletion = markforDeletion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostImpl other = (HostImpl)obj;
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }
}

