/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.Service;
import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.net.HostSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class RandomHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final HostHandler fallback;
    private final Service service;
    private Host origin;
    private Host current;

    public RandomHostHandler(HostResolver resolver, HostHandler fallback, Service service) {
        this.resolver = resolver;
        this.fallback = fallback;
        this.service = service;
        this.origin = this.current = this.getRandomHost(true, false);
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current == null) {
            this.origin = this.current = this.getRandomHost(false, true);
        }
        return this.current;
    }

    @Override
    public void success() {
        this.current = this.origin;
    }

    @Override
    public void fail() {
        this.fallback.fail();
        this.current = this.fallback.get(null, null);
    }

    private Host getRandomHost(boolean initial, boolean closeConnections) {
        ArrayList<Host> hosts = new ArrayList<Host>(this.resolver.resolve(this.service, initial, closeConnections).getHostsList());
        Collections.shuffle(hosts);
        return hosts.get(0);
    }

    @Override
    public void reset() {
        this.fallback.reset();
    }

    @Override
    public void confirm() {
    }

    @Override
    public void close() throws IOException {
        HostSet hosts = this.resolver.resolve(this.service, false, false);
        hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }
}

