/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.net;

import com.c8db.Service;
import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.net.HostSet;
import java.io.IOException;

public class RoundRobinHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final Service service;
    private int current;
    private int fails;
    private Host currentHost;

    public RoundRobinHostHandler(HostResolver resolver, Service service) {
        this.resolver = resolver;
        this.service = service;
        resolver.resolve(service, true, false);
        this.current = 0;
        this.fails = 0;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        HostSet hosts = this.resolver.resolve(this.service, false, false);
        int size = hosts.getHostsList().size();
        if (this.fails > size) {
            return null;
        }
        int index = this.current++ % size;
        Host host = hosts.getHostsList().get(index);
        if (hostHandle != null) {
            HostDescription hostDescription = hostHandle.getHost();
            if (hostDescription != null) {
                for (int i = index; i < index + size && !hostDescription.equals((host = hosts.getHostsList().get(i % size)).getDescription()); ++i) {
                }
            } else {
                hostHandle.setHost(host.getDescription());
            }
        }
        this.currentHost = host;
        return host;
    }

    @Override
    public void success() {
        this.fails = 0;
    }

    @Override
    public void fail() {
        ++this.fails;
    }

    @Override
    public void reset() {
        this.fails = 0;
    }

    @Override
    public void confirm() {
    }

    @Override
    public void close() throws IOException {
        HostSet hosts = this.resolver.resolve(this.service, false, false);
        hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.currentHost.closeOnError();
    }
}

