/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.util;

import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DBException;
import com.c8db.util.C8Serializer;
import java.util.Iterator;

public class C8SerializerImpl
implements C8Serializer {
    private final VPack vpacker;
    private final VPack vpackerNull;
    private final VPackParser vpackParser;

    public C8SerializerImpl(VPack vpacker, VPack vpackerNull, VPackParser vpackParser) {
        this.vpacker = vpacker;
        this.vpackerNull = vpackerNull;
        this.vpackParser = vpackParser;
    }

    @Override
    public VPackSlice serialize(Object entity) throws C8DBException {
        return this.serialize(entity, new C8Serializer.Options());
    }

    @Override
    public VPackSlice serialize(Object entity, C8Serializer.Options options) throws C8DBException {
        if (options.getType() == null) {
            options.type(entity.getClass());
        }
        try {
            VPackSlice vpack;
            Class<?> type = entity.getClass();
            boolean serializeNullValues = options.isSerializeNullValues();
            if (String.class.isAssignableFrom(type)) {
                vpack = this.vpackParser.fromJson((String)entity, serializeNullValues);
            } else if (options.isStringAsJson() && Iterable.class.isAssignableFrom(type)) {
                Iterator iterator = ((Iterable)Iterable.class.cast(entity)).iterator();
                if (iterator.hasNext() && String.class.isAssignableFrom(iterator.next().getClass())) {
                    vpack = this.vpackParser.fromJson((Iterable)entity, serializeNullValues);
                } else {
                    VPack vp = serializeNullValues ? this.vpackerNull : this.vpacker;
                    vpack = vp.serialize(entity, new VPack.SerializeOptions().type(options.getType()).additionalFields(options.getAdditionalFields()));
                }
            } else {
                VPack vp = serializeNullValues ? this.vpackerNull : this.vpacker;
                vpack = vp.serialize(entity, new VPack.SerializeOptions().type(options.getType()).additionalFields(options.getAdditionalFields()));
            }
            return vpack;
        }
        catch (VPackException e) {
            throw new C8DBException(e);
        }
    }
}

