/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.util;

import com.c8db.C8DBException;
import java.util.regex.Pattern;

public final class DocumentUtil {
    private static final String SLASH = "/";
    public static final String REGEX_KEY = "[^/]+";
    public static final String REGEX_ID = "[^/]+/[^/]+";

    private DocumentUtil() {
    }

    public static void validateIndexId(String id) {
        DocumentUtil.validateName("index id", REGEX_ID, id);
    }

    public static void validateDocumentKey(String key) throws C8DBException {
        DocumentUtil.validateName("document key", REGEX_KEY, key);
    }

    public static void validateDocumentId(String id) throws C8DBException {
        DocumentUtil.validateName("document id", REGEX_ID, id);
    }

    public static String createDocumentHandle(String collection, String key) {
        DocumentUtil.validateDocumentKey(key);
        return new StringBuffer().append(collection).append(SLASH).append(key).toString();
    }

    private static void validateName(String type, String regex, CharSequence name) throws C8DBException {
        if (!Pattern.matches(regex, name)) {
            throw new C8DBException(String.format("%s %s is not valid.", type, name));
        }
    }
}

