/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.util;

import com.arangodb.velocypack.exception.VPackParserException;
import com.c8db.C8DBException;
import com.c8db.entity.ErrorEntity;
import com.c8db.internal.net.C8DBRedirectException;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Response;
import java.lang.reflect.Type;

public final class ResponseUtils {
    private static final int ERROR_STATUS = 300;
    private static final int ERROR_INTERNAL = 503;
    private static final String HEADER_ENDPOINT = "X-C8-Endpoint";

    private ResponseUtils() {
    }

    public static void checkError(C8Serialization util, Response response) throws C8DBException {
        try {
            int responseCode = response.getResponseCode();
            if (responseCode >= 300) {
                if (responseCode == 503 && response.getMeta().containsKey(HEADER_ENDPOINT)) {
                    throw new C8DBRedirectException(String.format("Response Code: %s", responseCode), response.getMeta().get(HEADER_ENDPOINT));
                }
                if (responseCode == 503) {
                    throw new C8DBException(String.format("Response Code: %s", responseCode), responseCode);
                }
                if (response.getBody() != null) {
                    ErrorEntity errorEntity = (ErrorEntity)util.deserialize(response.getBody(), (Type)((Object)ErrorEntity.class));
                    if (errorEntity.getException() != null || errorEntity.getErrorMessage() != null || errorEntity.getCode() != 0 || errorEntity.getErrorNum() != 0) {
                        throw new C8DBException(errorEntity);
                    }
                    throw new C8DBException(response.getBody().toString(), responseCode);
                }
                throw new C8DBException(String.format("Response Code: %s", responseCode), responseCode);
            }
        }
        catch (VPackParserException e) {
            throw new C8DBException(e);
        }
    }
}

