/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.velocypack;

import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.BaseDocument;
import com.c8db.entity.BaseEdgeDocument;
import com.c8db.entity.CollectionModel;
import com.c8db.entity.CollectionStatus;
import com.c8db.entity.CollectionType;
import com.c8db.entity.FxType;
import com.c8db.entity.License;
import com.c8db.entity.LogLevel;
import com.c8db.entity.MinReplicationFactor;
import com.c8db.entity.Permissions;
import com.c8db.entity.QueryExecutionState;
import com.c8db.entity.ReplicationFactor;
import com.c8db.model.C8DynamoAttributeType;
import com.c8db.model.C8DynamoProjectionType;
import com.c8db.model.C8DynamoType;
import com.c8db.velocystream.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = new VPackDeserializer<Response>(){

        public Response deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            Response response = new Response();
            response.setVersion(vpack.get(0).getAsInt());
            response.setType(vpack.get(1).getAsInt());
            response.setResponseCode(vpack.get(2).getAsInt());
            if (vpack.size() > 3) {
                response.setMeta((Map)context.deserialize(vpack.get(3), Map.class));
            }
            return response;
        }
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = new VPackDeserializer<CollectionType>(){

        public CollectionType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionType.fromType(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<CollectionModel> COLLECTION_MODEL = new VPackDeserializer<CollectionModel>(){

        public CollectionModel deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionModel.fromType(vpack.getAsString());
        }
    };
    public static final VPackDeserializer<C8DynamoType> C8_DYNAMO_TYPE = new VPackDeserializer<C8DynamoType>(){

        public C8DynamoType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return C8DynamoType.fromKey(vpack.getAsString());
        }
    };
    public static final VPackDeserializer<C8DynamoAttributeType> C8_DYNAMO_ATTRIBUTE_TYPE = new VPackDeserializer<C8DynamoAttributeType>(){

        public C8DynamoAttributeType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return C8DynamoAttributeType.fromKey(vpack.getAsString());
        }
    };
    public static final VPackDeserializer<C8DynamoProjectionType> C8_DYNAMO_PROJECTION_TYPE = new VPackDeserializer<C8DynamoProjectionType>(){

        public C8DynamoProjectionType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return C8DynamoProjectionType.fromKey(vpack.getAsString());
        }
    };
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = new VPackDeserializer<CollectionStatus>(){

        public CollectionStatus deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionStatus.fromStatus(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = new VPackDeserializer<BaseDocument>(){

        public BaseDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new VPackDeserializer<BaseEdgeDocument>(){

        public BaseEdgeDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseEdgeDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<Date> DATE_STRING = new VPackDeserializer<Date>(){

        public Date deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            try {
                return new SimpleDateFormat(VPackDeserializers.DATE_TIME_FORMAT).parse(vpack.getAsString());
            }
            catch (ParseException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
                }
                return null;
            }
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = new VPackDeserializer<LogLevel>(){

        public LogLevel deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return LogLevel.fromLevel(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<License> LICENSE = new VPackDeserializer<License>(){

        public License deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return License.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<Permissions> PERMISSIONS = new VPackDeserializer<Permissions>(){

        public Permissions deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return Permissions.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<FxType> FX_TYPE = new VPackDeserializer<FxType>(){

        public FxType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return FxType.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = new VPackDeserializer<QueryExecutionState>(){

        public QueryExecutionState deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return QueryExecutionState.valueOf(vpack.getAsString().toUpperCase().replaceAll(" ", "_"));
        }
    };
    public static final VPackDeserializer<ReplicationFactor> REPLICATION_FACTOR = new VPackDeserializer<ReplicationFactor>(){

        public ReplicationFactor deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            ReplicationFactor replicationFactor = new ReplicationFactor();
            if (vpack.isString() && vpack.getAsString().equals("satellite")) {
                replicationFactor.setSatellite(true);
            } else {
                replicationFactor.setReplicationFactor(vpack.getAsInt());
            }
            return replicationFactor;
        }
    };
    public static final VPackDeserializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = new VPackDeserializer<MinReplicationFactor>(){

        public MinReplicationFactor deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            MinReplicationFactor minReplicationFactor = new MinReplicationFactor();
            minReplicationFactor.setMinReplicationFactor(vpack.getAsInt());
            return minReplicationFactor;
        }
    };
}

