/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.velocypack;

import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSerializationContext;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.BaseDocument;
import com.c8db.entity.BaseEdgeDocument;
import com.c8db.entity.CollectionModel;
import com.c8db.entity.CollectionType;
import com.c8db.entity.DocumentField;
import com.c8db.entity.LogLevel;
import com.c8db.entity.MinReplicationFactor;
import com.c8db.entity.Permissions;
import com.c8db.entity.ReplicationFactor;
import com.c8db.internal.velocystream.internal.AuthenticationRequest;
import com.c8db.model.C8DynamoAttributeType;
import com.c8db.model.C8DynamoProjectionType;
import com.c8db.model.C8DynamoType;
import com.c8db.model.TraversalOptions;
import com.c8db.velocystream.Request;
import java.util.HashMap;
import java.util.Map;

public class VPackSerializers {
    public static final VPackSerializer<Request> REQUEST = new VPackSerializer<Request>(){

        public void serialize(VPackBuilder builder, String attribute, Request value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, ValueType.ARRAY);
            builder.add(Integer.valueOf(value.getVersion()));
            builder.add(Integer.valueOf(value.getType()));
            builder.add(value.getDatabase());
            builder.add(Integer.valueOf(value.getRequestType().getType()));
            builder.add(value.getRequest());
            builder.add(ValueType.OBJECT);
            for (Map.Entry<String, String> entry : value.getQueryParam().entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            builder.close();
            builder.add(ValueType.OBJECT);
            for (Map.Entry<String, String> entry : value.getHeaderParam().entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            builder.close();
            builder.close();
        }
    };
    public static final VPackSerializer<AuthenticationRequest> AUTH_REQUEST = new VPackSerializer<AuthenticationRequest>(){

        public void serialize(VPackBuilder builder, String attribute, AuthenticationRequest value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, ValueType.ARRAY);
            builder.add(Integer.valueOf(value.getVersion()));
            builder.add(Integer.valueOf(value.getType()));
            builder.add(value.getEncryption());
            builder.add(value.getUser());
            builder.add(value.getPassword());
            builder.close();
        }
    };
    public static final VPackSerializer<CollectionType> COLLECTION_TYPE = new VPackSerializer<CollectionType>(){

        public void serialize(VPackBuilder builder, String attribute, CollectionType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, Integer.valueOf(value.getType()));
        }
    };
    public static final VPackSerializer<CollectionModel> COLLECTION_MODEL = new VPackSerializer<CollectionModel>(){

        public void serialize(VPackBuilder builder, String attribute, CollectionModel value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.getType());
        }
    };
    public static final VPackSerializer<C8DynamoType> C8_DYNAMO_TYPE = new VPackSerializer<C8DynamoType>(){

        public void serialize(VPackBuilder builder, String attribute, C8DynamoType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.getKey());
        }
    };
    public static final VPackSerializer<C8DynamoAttributeType> C8_DYNAMO_ATTRIBUTE_TYPE = new VPackSerializer<C8DynamoAttributeType>(){

        public void serialize(VPackBuilder builder, String attribute, C8DynamoAttributeType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.getKey());
        }
    };
    public static final VPackSerializer<C8DynamoProjectionType> C8_DYNAMO_PROJECTION_TYPE = new VPackSerializer<C8DynamoProjectionType>(){

        public void serialize(VPackBuilder builder, String attribute, C8DynamoProjectionType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.getKey());
        }
    };
    public static final VPackSerializer<BaseDocument> BASE_DOCUMENT = new VPackSerializer<BaseDocument>(){

        public void serialize(VPackBuilder builder, String attribute, BaseDocument value, VPackSerializationContext context) throws VPackException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
            doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
            doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
            context.serialize(builder, attribute, doc);
        }
    };
    public static final VPackSerializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new VPackSerializer<BaseEdgeDocument>(){

        public void serialize(VPackBuilder builder, String attribute, BaseEdgeDocument value, VPackSerializationContext context) throws VPackException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
            doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
            doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
            doc.put(DocumentField.Type.FROM.getSerializeName(), value.getFrom());
            doc.put(DocumentField.Type.TO.getSerializeName(), value.getTo());
            context.serialize(builder, attribute, doc);
        }
    };
    public static final VPackSerializer<TraversalOptions.Order> TRAVERSAL_ORDER = new VPackSerializer<TraversalOptions.Order>(){

        public void serialize(VPackBuilder builder, String attribute, TraversalOptions.Order value, VPackSerializationContext context) throws VPackException {
            if (TraversalOptions.Order.preorder_expander == value) {
                builder.add(attribute, "preorder-expander");
            } else {
                builder.add(attribute, value.name());
            }
        }
    };
    public static final VPackSerializer<LogLevel> LOG_LEVEL = new VPackSerializer<LogLevel>(){

        public void serialize(VPackBuilder builder, String attribute, LogLevel value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, Integer.valueOf(value.getLevel()));
        }
    };
    public static final VPackSerializer<Permissions> PERMISSIONS = new VPackSerializer<Permissions>(){

        public void serialize(VPackBuilder builder, String attribute, Permissions value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.toString().toLowerCase());
        }
    };
    public static final VPackSerializer<ReplicationFactor> REPLICATION_FACTOR = new VPackSerializer<ReplicationFactor>(){

        public void serialize(VPackBuilder builder, String attribute, ReplicationFactor value, VPackSerializationContext context) throws VPackException {
            Boolean satellite = value.getSatellite();
            if (Boolean.TRUE == satellite) {
                builder.add(attribute, "satellite");
            } else if (value.getReplicationFactor() != null) {
                builder.add(attribute, value.getReplicationFactor());
            }
        }
    };
    public static final VPackSerializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = new VPackSerializer<MinReplicationFactor>(){

        public void serialize(VPackBuilder builder, String attribute, MinReplicationFactor value, VPackSerializationContext context) throws VPackException {
            if (value.getMinReplicationFactor() != null) {
                builder.add(attribute, value.getMinReplicationFactor());
            }
        }
    };
}

