/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.velocystream;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.internal.net.AccessType;
import com.c8db.internal.net.C8DBRedirectException;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.util.HostUtils;
import com.c8db.internal.util.RequestUtils;
import com.c8db.internal.util.ResponseUtils;
import com.c8db.internal.velocystream.internal.Chunk;
import com.c8db.internal.velocystream.internal.Message;
import com.c8db.internal.velocystream.internal.VstConnection;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VstCommunication<R, C extends VstConnection>
implements Closeable {
    protected static final String ENCRYPTION_PLAIN = "plain";
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunication.class);
    protected static final AtomicLong mId = new AtomicLong(0L);
    protected final C8Serialization util;
    protected final String user;
    protected final String password;
    protected final Integer chunksize;
    private final Map<Service, HostHandler> hostHandlerMatrix;

    protected VstCommunication(Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, C8Serialization util, Integer chunksize, Map<Service, HostHandler> hostHandlerMatrix) {
        this.user = user;
        this.password = password;
        this.util = util;
        this.hostHandlerMatrix = hostHandlerMatrix;
        this.chunksize = chunksize != null ? chunksize : 30000;
    }

    protected synchronized C connect(HostHandle hostHandle, AccessType accessType, Service service) {
        HostHandler hostHandler = this.hostHandlerMatrix.get((Object)service);
        Host host = hostHandler.get(hostHandle, accessType);
        while (true) {
            if (host == null) {
                hostHandler.reset();
                throw new C8DBException("Was not able to connect to any host");
            }
            VstConnection connection = (VstConnection)host.connection();
            if (connection.isOpen()) {
                return (C)connection;
            }
            try {
                connection.open();
                hostHandler.success();
                if (this.user != null) {
                    this.authenticate(connection);
                }
                hostHandler.confirm();
                return (C)connection;
            }
            catch (IOException e) {
                hostHandler.fail();
                if (hostHandle != null && hostHandle.getHost() != null) {
                    hostHandle.setHost(null);
                }
                Host failedHost = host;
                host = hostHandler.get(hostHandle, accessType);
                if (host != null) {
                    LOGGER.warn(String.format("Could not connect to %s or SSL Handshake failed. Try connecting to %s", failedHost.getDescription(), host.getDescription()));
                    continue;
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new C8DBException(e);
            }
            break;
        }
    }

    protected abstract void authenticate(C var1);

    @Override
    public void close() throws IOException {
        for (HostHandler hostHandler : this.hostHandlerMatrix.values()) {
            hostHandler.close();
        }
    }

    public R execute(Request request, HostHandle hostHandle, Service service) throws C8DBException {
        try {
            C connection = this.connect(hostHandle, RequestUtils.determineAccessType(request), service);
            return this.execute(request, connection);
        }
        catch (C8DBException e) {
            if (e instanceof C8DBRedirectException) {
                String location = ((C8DBRedirectException)C8DBRedirectException.class.cast(e)).getLocation();
                HostDescription redirectHost = HostUtils.createFromLocation(location);
                HostHandler hostHandler = this.hostHandlerMatrix.get((Object)service);
                hostHandler.closeCurrentOnError();
                hostHandler.fail();
                return this.execute(request, new HostHandle().setHost(redirectHost), service);
            }
            throw e;
        }
    }

    protected abstract R execute(Request var1, C var2) throws C8DBException;

    protected void checkError(Response response) throws C8DBException {
        ResponseUtils.checkError(this.util, response);
    }

    protected Response createResponse(Message message) throws VPackParserException {
        Response response = (Response)this.util.deserialize(message.getHead(), (Type)((Object)Response.class));
        if (message.getBody() != null) {
            response.setBody(message.getBody());
        }
        return response;
    }

    protected Message createMessage(Request request) throws VPackParserException {
        long id = mId.incrementAndGet();
        return new Message(id, this.util.serialize(request), request.getBody());
    }

    protected Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunksize;
        int numberOfChunks = size % this.chunksize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunksize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }
}

