/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.velocystream;

import com.arangodb.velocypack.exception.VPackParserException;
import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.velocystream.VstCommunication;
import com.c8db.internal.velocystream.internal.AuthenticationRequest;
import com.c8db.internal.velocystream.internal.Message;
import com.c8db.internal.velocystream.internal.VstConnectionSync;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstCommunicationSync
extends VstCommunication<Response, VstConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunicationSync.class);

    protected VstCommunicationSync(Map<Service, HostHandler> hostHandlerMatrix, Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, C8Serialization util, Integer chunksize, Integer maxConnections, Long ttl) {
        super(timeout, user, password, useSsl, sslContext, util, chunksize, hostHandlerMatrix);
    }

    @Override
    protected Response execute(Request request, VstConnectionSync connection) throws C8DBException {
        try {
            Message requestMessage = this.createMessage(request);
            Message responseMessage = this.send(requestMessage, connection);
            Response response = this.createResponse(responseMessage);
            this.checkError(response);
            return response;
        }
        catch (VPackParserException e) {
            throw new C8DBException(e);
        }
    }

    private Message send(Message message, VstConnectionSync connection) throws C8DBException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Send Message (id=%s, head=%s, body=%s)", message.getId(), message.getHead(), message.getBody() != null ? message.getBody() : "{}"));
        }
        return connection.write(message, this.buildChunks(message));
    }

    @Override
    protected void authenticate(VstConnectionSync connection) {
        Response response = this.execute((Request)new AuthenticationRequest(this.user, this.password != null ? this.password : "", "plain"), connection);
        this.checkError(response);
    }

    public static class Builder {
        private final Map<Service, HostHandler> hostHandlerMatrix;
        private Integer timeout;
        private Long connectionTtl;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer chunksize;
        private Integer maxConnections;

        public Builder(Map<Service, HostHandler> hostHandlerMatrix) {
            this.hostHandlerMatrix = hostHandlerMatrix;
        }

        public Builder(Builder builder) {
            this(builder.hostHandlerMatrix);
            this.timeout(builder.timeout).user(builder.user).password(builder.password).useSsl(builder.useSsl).sslContext(builder.sslContext).chunksize(builder.chunksize).maxConnections(builder.maxConnections);
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.chunksize = chunksize;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public VstCommunication<Response, VstConnectionSync> build(C8Serialization util) {
            return new VstCommunicationSync(this.hostHandlerMatrix, this.timeout, this.user, this.password, this.useSsl, this.sslContext, util, this.chunksize, this.maxConnections, this.connectionTtl);
        }
    }
}

