/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.jackson.dataformat.velocypack.internal;

import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackBuilderException;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class VPackGenerator
extends GeneratorBase {
    private final VPackBuilder builder = new VPackBuilder();
    private final OutputStream out;
    private String attribute = null;

    public VPackGenerator(int features, ObjectCodec codec, OutputStream out) {
        super(features, codec);
        this.out = out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
    }

    public void writeStartArray() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.ARRAY);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeEndArray() throws IOException {
        try {
            this.builder.close();
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeStartObject() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.OBJECT);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeEndObject() throws IOException {
        try {
            this.builder.close();
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeFieldName(String name) throws IOException {
        this.attribute = name;
    }

    public void writeString(String text) throws IOException {
        try {
            this.builder.add(this.attribute, text);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        try {
            this.builder.add(this.attribute, new String(text, offset, len));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        try {
            this.builder.add(this.attribute, new String(text, offset, length));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        try {
            this.builder.add(this.attribute, new String(text, offset, length));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeRaw(String text) throws IOException {
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
    }

    public void writeRaw(char c) throws IOException {
        try {
            this.builder.add(this.attribute, Character.valueOf(c));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        try {
            this.builder.add(this.attribute, bv.encode(data, false));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeVPack(VPackSlice vpack) throws IOException {
        try {
            this.builder.add(this.attribute, vpack);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(int v) throws IOException {
        try {
            this.builder.add(this.attribute, Integer.valueOf(v));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(long v) throws IOException {
        try {
            this.builder.add(this.attribute, Long.valueOf(v));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        try {
            this.builder.add(this.attribute, v);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(double v) throws IOException {
        try {
            this.builder.add(this.attribute, Double.valueOf(v));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(float v) throws IOException {
        try {
            this.builder.add(this.attribute, Float.valueOf(v));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        try {
            this.builder.add(this.attribute, v);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNumber(String encodedValue) throws IOException {
    }

    public void writeBoolean(boolean state) throws IOException {
        try {
            this.builder.add(this.attribute, Boolean.valueOf(state));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeNull() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.NULL);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.out.write(this.builder.slice().getBuffer());
        super.close();
    }
}

