/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.jackson.dataformat.velocypack.internal;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class VPackParser
extends ParserMinimalBase {
    private VPackSlice currentValue;
    private String currentName;
    private final LinkedList<Iterator<Map.Entry<String, VPackSlice>>> objectIterators;
    private final LinkedList<Iterator<VPackSlice>> arrayIterators;
    private final LinkedList<JsonToken> currentCompoundValue;
    private ObjectCodec codec;

    public VPackParser(byte[] data, int offset, int features) {
        super(features);
        this.currentValue = new VPackSlice(data, offset);
        this._currToken = null;
        this.objectIterators = new LinkedList();
        this.arrayIterators = new LinkedList();
        this.currentCompoundValue = new LinkedList();
    }

    public JsonToken nextToken() throws IOException {
        if (this._currToken == null) {
            this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            return this._currToken;
        }
        if (this._currToken == JsonToken.START_OBJECT) {
            this.objectIterators.add(this.currentValue.objectIterator());
            this.currentCompoundValue.add(JsonToken.START_OBJECT);
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this.arrayIterators.add(this.currentValue.arrayIterator());
            this.currentCompoundValue.add(JsonToken.START_ARRAY);
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            return this._currToken;
        }
        if (this.currentCompoundValue.getLast() == JsonToken.START_OBJECT && !this.objectIterators.isEmpty()) {
            Iterator<Map.Entry<String, VPackSlice>> lastObject = this.objectIterators.getLast();
            if (lastObject.hasNext()) {
                Map.Entry<String, VPackSlice> next = lastObject.next();
                this.currentName = next.getKey();
                this.currentValue = next.getValue();
                this._currToken = JsonToken.FIELD_NAME;
            } else {
                this._currToken = JsonToken.END_OBJECT;
                this.objectIterators.removeLast();
                this.currentCompoundValue.removeLast();
            }
        } else if (this.currentCompoundValue.getLast() == JsonToken.START_ARRAY && !this.arrayIterators.isEmpty()) {
            Iterator<VPackSlice> lastArray = this.arrayIterators.getLast();
            if (lastArray.hasNext()) {
                this.currentName = null;
                this.currentValue = lastArray.next();
                this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            } else {
                this._currToken = JsonToken.END_ARRAY;
                this.arrayIterators.removeLast();
                this.currentCompoundValue.removeLast();
            }
        }
        return this._currToken;
    }

    private JsonToken getToken(ValueType type, VPackSlice value) {
        JsonToken token;
        switch (type) {
            case OBJECT: {
                token = JsonToken.START_OBJECT;
                break;
            }
            case ARRAY: {
                token = JsonToken.START_ARRAY;
                break;
            }
            case STRING: {
                token = JsonToken.VALUE_STRING;
                break;
            }
            case BOOL: {
                token = value.isTrue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case DOUBLE: {
                token = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case INT: 
            case SMALLINT: 
            case UINT: {
                token = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case NULL: {
                token = JsonToken.VALUE_NULL;
                break;
            }
            default: {
                token = null;
            }
        }
        return token;
    }

    protected void _handleEOF() throws JsonParseException {
    }

    public String getCurrentName() throws IOException {
        return this.currentName;
    }

    public void close() throws IOException {
    }

    public boolean isClosed() {
        return false;
    }

    public JsonStreamContext getParsingContext() {
        return null;
    }

    public void overrideCurrentName(String name) {
        this.currentName = name;
    }

    public String getText() throws IOException {
        return this._currToken == JsonToken.FIELD_NAME ? this.currentName : this.currentValue.getAsString();
    }

    public char[] getTextCharacters() throws IOException {
        return null;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public int getTextLength() throws IOException {
        return this.currentValue.getLength();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this.currentValue.isBinary()) {
            return this.currentValue.getAsBinary();
        }
        if (this.currentValue.isString()) {
            return b64variant.decode(this.currentValue.getAsString());
        }
        return Arrays.copyOfRange(this.currentValue.getBuffer(), this.currentValue.getStart(), this.currentValue.getStart() + this.currentValue.getByteSize());
    }

    public VPackSlice getVPack() throws IOException {
        return this.currentValue;
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec c) {
        this.codec = c;
    }

    public Version version() {
        return null;
    }

    public JsonLocation getTokenLocation() {
        return null;
    }

    public JsonLocation getCurrentLocation() {
        return null;
    }

    public Number getNumberValue() throws IOException {
        return this.currentValue.getAsNumber();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        JsonParser.NumberType type;
        switch (this.currentValue.getType()) {
            case SMALLINT: {
                type = JsonParser.NumberType.INT;
                break;
            }
            case INT: {
                type = JsonParser.NumberType.LONG;
                break;
            }
            case UINT: {
                type = JsonParser.NumberType.BIG_INTEGER;
                break;
            }
            case DOUBLE: {
                type = JsonParser.NumberType.DOUBLE;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    public int getIntValue() throws IOException {
        return this.currentValue.getAsInt();
    }

    public long getLongValue() throws IOException {
        return this.currentValue.getAsLong();
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentValue.getAsBigInteger();
    }

    public float getFloatValue() throws IOException {
        return this.currentValue.getAsFloat();
    }

    public double getDoubleValue() throws IOException {
        return this.currentValue.getAsDouble();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this.currentValue.getAsBigDecimal();
    }
}

