/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.model;

import com.c8db.entity.EdgeDefinition;
import java.util.Arrays;
import java.util.Collection;

public class GraphCreateOptions {
    private String name;
    private Collection<EdgeDefinition> edgeDefinitions;
    private Collection<String> orphanCollections;
    private SmartOptions options;

    protected String getName() {
        return this.name;
    }

    protected GraphCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public Collection<EdgeDefinition> getEdgeDefinitions() {
        return this.edgeDefinitions;
    }

    protected GraphCreateOptions edgeDefinitions(Collection<EdgeDefinition> edgeDefinitions) {
        this.edgeDefinitions = edgeDefinitions;
        return this;
    }

    public Collection<String> getOrphanCollections() {
        return this.orphanCollections;
    }

    public GraphCreateOptions orphanCollections(String ... orphanCollections) {
        this.orphanCollections = Arrays.asList(orphanCollections);
        return this;
    }

    public Integer getNumberOfShards() {
        return this.getOptions().getNumberOfShards();
    }

    public GraphCreateOptions numberOfShards(Integer numberOfShards) {
        this.getOptions().setNumberOfShards(numberOfShards);
        return this;
    }

    private SmartOptions getOptions() {
        if (this.options == null) {
            this.options = new SmartOptions();
        }
        return this.options;
    }

    public static class SmartOptions {
        private Integer numberOfShards;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }
    }
}

