/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.model;

import com.c8db.C8DBException;
import com.c8db.entity.IndexType;
import com.c8db.model.FulltextIndexOptions;
import com.c8db.model.GeoIndexOptions;
import com.c8db.model.HashIndexOptions;
import com.c8db.model.PersistentIndexOptions;
import com.c8db.model.SkiplistIndexOptions;
import com.c8db.model.TTLIndexOptions;

public class IndexOptions {
    private final IndexType type;
    private Boolean inBackground;
    private String name;

    public IndexOptions(IndexType type) {
        this.type = type;
    }

    public IndexOptions inBackground(Boolean inBackground) {
        this.inBackground = inBackground;
        return this;
    }

    public Boolean getInBackground() {
        return this.inBackground;
    }

    public IndexType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public static IndexOptions create(IndexType indexType) {
        switch (indexType) {
            case hash: {
                return new HashIndexOptions();
            }
            case skiplist: {
                return new SkiplistIndexOptions();
            }
            case persistent: {
                return new PersistentIndexOptions();
            }
            case geo: {
                return new GeoIndexOptions();
            }
            case fulltext: {
                return new FulltextIndexOptions();
            }
            case ttl: {
                return new TTLIndexOptions();
            }
        }
        throw new C8DBException(String.format("Creating index options for index type %s not supported.", indexType.getValue()));
    }
}

