/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.model;

import com.arangodb.velocypack.VPackSlice;
import com.c8db.entity.EdgeDefinition;
import com.c8db.entity.Permissions;
import com.c8db.entity.UserQueryOptions;
import com.c8db.model.ApiKeyCreateOptions;
import com.c8db.model.ApiKeyOptions;
import com.c8db.model.C8KVCreateOptions;
import com.c8db.model.C8TransactionOptions;
import com.c8db.model.C8qlQueryExplainOptions;
import com.c8db.model.C8qlQueryOptions;
import com.c8db.model.C8qlQueryParseOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.CollectionRenameOptions;
import com.c8db.model.DBCreateOptions;
import com.c8db.model.DCListOptions;
import com.c8db.model.FulltextIndexOptions;
import com.c8db.model.GeoIndexOptions;
import com.c8db.model.GraphCreateOptions;
import com.c8db.model.HashIndexOptions;
import com.c8db.model.PersistentIndexOptions;
import com.c8db.model.SkiplistIndexOptions;
import com.c8db.model.TTLIndexOptions;
import com.c8db.model.UserAccessOptions;
import com.c8db.model.UserCreateOptions;
import com.c8db.model.VertexCollectionCreateOptions;
import java.util.Collection;
import java.util.HashMap;

public class OptionsBuilder {
    private OptionsBuilder() {
    }

    public static UserCreateOptions build(UserCreateOptions options, String user, String passwd, String email) {
        return options.user(user).passwd(passwd).email(email);
    }

    public static HashIndexOptions build(HashIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static SkiplistIndexOptions build(SkiplistIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static PersistentIndexOptions build(PersistentIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static GeoIndexOptions build(GeoIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static FulltextIndexOptions build(FulltextIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static TTLIndexOptions build(TTLIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static CollectionCreateOptions build(CollectionCreateOptions options, String name) {
        return options.name(name);
    }

    public static C8KVCreateOptions build(C8KVCreateOptions options, String name) {
        return options.name(name);
    }

    public static C8qlQueryOptions build(C8qlQueryOptions options, String query, VPackSlice bindVars) {
        return options.query(query).bindVars(bindVars);
    }

    public static C8qlQueryExplainOptions build(C8qlQueryExplainOptions options, String query, VPackSlice bindVars) {
        return options.query(query).bindVars(bindVars);
    }

    public static C8qlQueryParseOptions build(C8qlQueryParseOptions options, String query) {
        return options.query(query);
    }

    public static GraphCreateOptions build(GraphCreateOptions options, String name, Collection<EdgeDefinition> edgeDefinitions) {
        return options.name(name).edgeDefinitions(edgeDefinitions);
    }

    public static C8TransactionOptions build(C8TransactionOptions options, String action) {
        return options.action(action);
    }

    public static CollectionRenameOptions build(CollectionRenameOptions options, String name) {
        return options.name(name);
    }

    public static DBCreateOptions build(DBCreateOptions options, String tenant, String name, String spotDc, String dcList) {
        return options.geoFabric(tenant, name).options(spotDc, dcList);
    }

    public static DCListOptions build(DCListOptions options, String dcList) {
        return options.dcList(dcList);
    }

    public static UserAccessOptions build(UserAccessOptions options, Permissions grant) {
        return options.grant(grant);
    }

    public static VertexCollectionCreateOptions build(VertexCollectionCreateOptions options, String collection) {
        return options.collection(collection);
    }

    public static UserQueryOptions build(UserQueryOptions options, String name) {
        if (options.getParameter() == null) {
            options.parameter(new HashMap<String, Object>());
        }
        return options.name(name);
    }

    public static ApiKeyOptions build(ApiKeyOptions options, String apiKey) {
        return options.apiKey(apiKey);
    }

    public static ApiKeyCreateOptions build(ApiKeyCreateOptions options, String keyId) {
        return options.keyId(keyId);
    }
}

