/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.util;

import com.amazonaws.services.dynamodbv2.document.ItemUtils;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.c8db.entity.C8DynamoAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class C8DynamoUtils {
    public static Collection<Map<String, Object>> toOriginalListOfItems(Collection<Map<String, C8DynamoAttributeValue>> value) {
        ArrayList<Map<String, Object>> list = null;
        if (value != null) {
            list = new ArrayList<Map<String, Object>>();
            for (Map<String, C8DynamoAttributeValue> item : value) {
                list.add(C8DynamoUtils.toOriginalItem(item));
            }
        }
        return list;
    }

    public static Map<String, AttributeValue> toDynamoItem(Map<String, Object> value) {
        HashMap<String, AttributeValue> map = null;
        if (value != null) {
            map = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                map.put(entry.getKey(), ItemUtils.toAttributeValue((Object)entry.getValue()));
            }
        }
        return map;
    }

    public static Map<String, Object> toOriginalItem(Map<String, C8DynamoAttributeValue> value) {
        HashMap<String, Object> map = null;
        if (value != null) {
            map = new HashMap<String, Object>();
            for (Map.Entry<String, C8DynamoAttributeValue> entry : value.entrySet()) {
                map.put(entry.getKey(), C8DynamoUtils.toOriginalAttribute(entry.getValue()));
            }
        }
        return map;
    }

    public static Object toOriginalAttribute(C8DynamoAttributeValue value) {
        if (value.getS() != null) {
            return value.getS();
        }
        if (value.getN() != null) {
            return value.getN();
        }
        if (value.getB() != null) {
            return value.getB();
        }
        if (value.getSS() != null) {
            return value.getSS();
        }
        if (value.getNS() != null) {
            return value.getNS();
        }
        if (value.getBS() != null) {
            return value.getBS();
        }
        if (value.getM() != null) {
            return C8DynamoUtils.toOriginalItem(value.getM());
        }
        if (value.getL() != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (C8DynamoAttributeValue attributeValue : value.getL()) {
                list.add(C8DynamoUtils.toOriginalAttribute(attributeValue));
            }
            return list;
        }
        if (value.getNULL().booleanValue()) {
            return null;
        }
        if (value.getBOOL().booleanValue()) {
            return value.getBOOL();
        }
        return null;
    }
}

