/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.velocystream;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.annotations.Expose;
import com.c8db.velocystream.RequestType;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private int version = 1;
    private int type = 1;
    private final String tenant;
    private final String database;
    private final RequestType requestType;
    private final boolean retryEnabled;
    private final String request;
    private final Map<String, String> queryParam;
    private final Map<String, String> headerParam;
    @Expose(serialize=false)
    private VPackSlice body;

    public Request(String tenant, String database, RequestType requestType, String path) {
        this(tenant, database, requestType, true, path);
    }

    public Request(String tenant, String database, RequestType requestType, boolean retryEnabled, String path) {
        this.tenant = tenant;
        this.database = database;
        this.request = path;
        this.requestType = requestType;
        this.body = null;
        this.queryParam = new HashMap<String, String>();
        this.headerParam = new HashMap<String, String>();
        this.retryEnabled = retryEnabled;
    }

    public int getVersion() {
        return this.version;
    }

    public Request setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public Request setType(int type) {
        this.type = type;
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getDatabase() {
        return this.database;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getRequest() {
        return this.request;
    }

    public Map<String, String> getQueryParam() {
        return this.queryParam;
    }

    public Request putQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParam.put(key, value.toString());
        }
        return this;
    }

    public Map<String, String> getHeaderParam() {
        return this.headerParam;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public Request putHeaderParam(String key, String value) {
        if (value != null) {
            this.headerParam.put(key, value);
        }
        return this;
    }

    public VPackSlice getBody() {
        return this.body;
    }

    public Request setBody(VPackSlice body) {
        this.body = body;
        return this;
    }
}

