/*
 * Decompiled with CFR 0.152.
 */
package co.ntier.mongo.tomcat;

import co.ntier.mongo.tomcat.MongoSerializer;
import co.ntier.mongo.tomcat.MongoSession;
import co.ntier.mongo.tomcat.MongoSessionTrackerValve;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.StandardSession;

public class MongoSessionManager
implements Manager,
Lifecycle {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final ServerAddress serverAddress;
    private final String databaseName;
    private final String username;
    private final char[] password;
    private Mongo mongo;
    private DB db;
    private boolean slaveOk;
    private LifecycleState state = LifecycleState.NEW;
    private ThreadLocal<StandardSession> currentSession = new ThreadLocal();
    private MongoSessionTrackerValve trackerValve;
    private MongoSerializer serializer;
    private String serializationStrategyClass = MongoSerializer.class.getName();
    private Container container;
    private int maxInactiveInterval = 1800;
    private int maxActive = 1000000;

    public MongoSessionManager(ServerAddress serverAddress, String databaseName, String username, String password) {
        this.serverAddress = serverAddress;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password.toCharArray();
    }

    public void start() throws LifecycleException {
        boolean found = false;
        for (Valve valve : this.getContainer().getPipeline().getValves()) {
            if (!(valve instanceof MongoSessionTrackerValve)) continue;
            this.trackerValve = (MongoSessionTrackerValve)valve;
            this.trackerValve.setMongoManager(this);
            this.log.info("Attached to Mongo Tracker Valve");
            found = true;
            break;
        }
        if (!found) {
            this.log.warning(String.format("Did not find %s valve to attach MongoManager", MongoSessionTrackerValve.class.getSimpleName()));
        }
        try {
            this.initSerializer();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Unable to load serializer", e);
            throw new LifecycleException((Throwable)e);
        }
        this.log.info("Will expire sessions after " + this.getMaxInactiveInterval() + " seconds");
        this.initDbConnection();
    }

    public void stop() throws LifecycleException {
        this.state = LifecycleState.STOPPING;
        this.mongo.close();
        this.state = LifecycleState.STOPPED;
    }

    public Session createEmptySession() {
        MongoSession session = new MongoSession(this);
        session.setId(UUID.randomUUID().toString());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setNew(true);
        this.currentSession.set(session);
        this.log.fine("Created new empty session " + session.getIdInternal());
        return session;
    }

    public void backgroundProcess() {
        BasicDBObject query = new BasicDBObject();
        long olderThan = System.currentTimeMillis() - (long)(this.getMaxInactiveInterval() * 1000);
        this.log.fine("Looking for sessions less than for expiry in Mongo : " + olderThan);
        query.put("lastmodified", (Object)new BasicDBObject("$lt", (Object)olderThan));
        try {
            WriteResult result = this.getCollection().remove((DBObject)query);
            this.log.fine("Expired sessions : " + result.getN());
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error cleaning session in Mongo Session Store", e);
        }
    }

    public void add(Session session) {
        try {
            this.save(session);
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "Error adding new session", ex);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public boolean getDistributable() {
        return false;
    }

    public void setDistributable(boolean b) {
    }

    public String getInfo() {
        return "Mongo Session Manager";
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int i) {
        this.maxInactiveInterval = i;
    }

    public int getSessionIdLength() {
        return 37;
    }

    public void setSessionIdLength(int i) {
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int i) {
        this.maxActive = i;
    }

    public int getActiveSessions() {
        return 1000000;
    }

    public int getRejectedSessions() {
        return 0;
    }

    public void setSerializationStrategyClass(String strategy) {
        this.serializationStrategyClass = strategy;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    public boolean getSlaveOk() {
        return this.slaveOk;
    }

    public void setRejectedSessions(int i) {
    }

    public int getSessionMaxAliveTime() {
        return this.maxInactiveInterval;
    }

    public void setSessionMaxAliveTime(int i) {
    }

    public int getSessionAverageAliveTime() {
        return 0;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public LifecycleListener[] findLifecycleListeners() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void changeSessionId(Session session) {
        session.setId(UUID.randomUUID().toString());
    }

    public Session createSession(String sessionId) {
        MongoSession session = (MongoSession)this.createEmptySession();
        this.log.fine("Created session with id " + session.getIdInternal() + " ( " + sessionId + ")");
        if (sessionId != null) {
            session.setId(sessionId);
        }
        return session;
    }

    public Session[] findSessions() {
        try {
            ArrayList<Session> sessions = new ArrayList<Session>();
            for (String sessionId : this.keys()) {
                sessions.add(this.loadSession(sessionId));
            }
            return sessions.toArray(new Session[sessions.size()]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Session findSession(String id) throws IOException {
        return this.loadSession(id);
    }

    private DBCollection getCollection() throws IOException {
        return this.db.getCollection("sessions");
    }

    private String[] keys() throws IOException {
        BasicDBObject restrict = new BasicDBObject();
        restrict.put("_id", (Object)1);
        DBCursor cursor = this.getCollection().find((DBObject)new BasicDBObject(), (DBObject)restrict);
        ArrayList<String> ret = new ArrayList<String>();
        while (cursor.hasNext()) {
            ret.add(cursor.next().get("").toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    private Session loadSession(String id) throws IOException {
        if (id == null || id.length() == 0) {
            return this.createEmptySession();
        }
        StandardSession session = this.currentSession.get();
        if (session != null) {
            if (id.equals(session.getId())) {
                return session;
            }
            this.currentSession.remove();
        }
        try {
            this.log.fine("Loading session " + id + " from Mongo");
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)id);
            DBObject dbsession = this.getCollection().findOne((DBObject)query);
            if (dbsession == null) {
                this.log.fine("Session " + id + " not found in Mongo");
                MongoSession ret = (MongoSession)this.createEmptySession();
                ret.setId(id);
                this.currentSession.set(ret);
                return ret;
            }
            byte[] data = (byte[])dbsession.get("data");
            session = (MongoSession)this.createEmptySession();
            session.setId(id);
            session.setManager((Manager)this);
            this.serializer.deserialize(data, (HttpSession)session);
            session.setMaxInactiveInterval(-1);
            session.access();
            session.setValid(true);
            session.setNew(false);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Session Contents [" + session.getId() + "]:");
                for (String name : Collections.list(session.getAttributeNames())) {
                    this.log.fine("  " + name);
                }
            }
            this.log.fine("Loaded session id " + id);
            this.currentSession.set(session);
            return session;
        }
        catch (IOException e) {
            this.log.severe(e.getMessage());
            throw e;
        }
        catch (ClassNotFoundException ex) {
            this.log.log(Level.SEVERE, "Unable to deserialize session ", ex);
            throw new IOException("Unable to deserializeInto session", ex);
        }
    }

    private void save(Session session) throws IOException {
        try {
            this.log.fine("Saving session " + session + " into Mongo");
            MongoSession standardsession = (MongoSession)session;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Session Contents [" + session.getId() + "]:");
                for (String name : Collections.list(standardsession.getAttributeNames())) {
                    this.log.fine("  " + name);
                }
            }
            byte[] data = this.serializer.serialize((HttpSession)standardsession);
            BasicDBObject dbsession = new BasicDBObject();
            dbsession.put("_id", (Object)standardsession.getId());
            dbsession.put("data", (Object)data);
            dbsession.put("lastmodified", (Object)System.currentTimeMillis());
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)standardsession.getIdInternal());
            this.getCollection().update((DBObject)query, (DBObject)dbsession, true, false);
            this.log.fine("Updated session with id " + session.getIdInternal());
        }
        catch (IOException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            this.currentSession.remove();
            this.log.fine("Session removed from ThreadLocal :" + session.getIdInternal());
        }
    }

    public void remove(Session session) {
        this.remove(session, true);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void initDbConnection() throws LifecycleException {
        try {
            this.mongo = new Mongo(this.serverAddress);
            this.db = this.mongo.getDB(this.databaseName);
            if (this.username != null && this.password != null) {
                this.db.authenticate(this.username, this.password);
            }
            if (this.slaveOk) {
                this.db.slaveOk();
            }
            this.getCollection().ensureIndex((DBObject)new BasicDBObject("lastmodified", (Object)1));
            int ttl = this.getMaxInactiveInterval() * 1000;
            String msg = String.format("Connected MongoManager to %s/%s (slave: %s; TTL: %s)", this.serverAddress, this.databaseName, this.slaveOk, ttl);
            this.log.info(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LifecycleException("Error Connecting to Mongo", (Throwable)e);
        }
    }

    private void initSerializer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.log.info("Attempting to use serializer :" + this.serializationStrategyClass);
        this.serializer = (MongoSerializer)Class.forName(this.serializationStrategyClass).newInstance();
        Loader loader = null;
        if (this.container != null) {
            loader = this.container.getLoader();
        }
        ClassLoader classLoader = null;
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        this.serializer.setClassLoader(classLoader);
    }

    public void init() throws LifecycleException {
    }

    public void destroy() throws LifecycleException {
    }

    public LifecycleState getState() {
        return this.state;
    }

    public String getStateName() {
        return this.state.toString();
    }

    public long getSessionCounter() {
        return 10000000L;
    }

    public void setSessionCounter(long sessionCounter) {
    }

    public long getExpiredSessions() {
        return 0L;
    }

    public void setExpiredSessions(long expiredSessions) {
    }

    public int getSessionCreateRate() {
        return 0;
    }

    public int getSessionExpireRate() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, boolean update) {
        this.log.fine("Removing session ID : " + session.getId());
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)session.getId());
        try {
            this.getCollection().remove((DBObject)query);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error removing session in Mongo Session Store", e);
        }
        finally {
            this.currentSession.remove();
        }
    }
}

