/*
 * Decompiled with CFR 0.152.
 */
package co.ntier.mongo.tomcat;

import co.ntier.mongo.tomcat.MongoSessionManager;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class MongoSessionTrackerValve
extends ValveBase {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private MongoSessionManager manager;

    public void setMongoManager(MongoSessionManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.storeSession(request, response);
        }
    }

    private void storeSession(Request request, Response response) throws IOException {
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return;
        }
        if (session.isValid()) {
            this.log.fine(String.format("Request with session completed, saving session %s", session.getId()));
            if (session.getSession() == null) {
                this.log.fine("No HTTP Session present, Not saving " + session.getId());
            } else {
                this.log.fine("HTTP Session present, saving " + session.getId());
                this.manager.add(session);
            }
        } else {
            this.log.fine("HTTP Session has been invalidated, removing :" + session.getId());
            this.manager.remove(session);
        }
    }
}

