/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ApplicationOptions;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.Window;
import com.openfin.desktop.WindowOptions;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger((String)Application.class.getName());
    DesktopConnection connection;
    ApplicationOptions options;
    JSONObject noParamPayload;
    JSONObject resizeToPayload;
    JSONObject resizeByPayload;
    JSONObject moveToPayload;
    JSONObject moveByPayload;
    JSONObject dockWindowPayload;
    JSONObject eventListenerPayload;
    Window window;
    String uuid;
    EventListener trayIconClickListener;

    public static Application wrap(String uuid, DesktopConnection connection) {
        return new Application(uuid, connection);
    }

    private Application(String uuid, DesktopConnection connection) {
        this.uuid = uuid;
        this.connection = connection;
        this.initialize();
    }

    public Application(ApplicationOptions options, DesktopConnection connection, AckListener listener) {
        this.options = options;
        this.connection = connection;
        this.uuid = this.options.getUUID();
        this.initialize();
        connection.sendAction("create-application", this.options.getJson(), listener, this);
    }

    public void run() throws DesktopException {
        this.connection.sendAction("run-application", this.noParamPayload);
    }

    public void run(AckListener listener) {
        this.connection.sendAction("run-application", this.noParamPayload, listener, this);
    }

    public void restart() throws DesktopException {
        this.connection.sendAction("restart-application", this.noParamPayload);
    }

    public void restart(AckListener listener) {
        this.connection.sendAction("restart-application", this.noParamPayload, listener, this);
    }

    public void close() throws DesktopException {
        this.connection.sendAction("close-application", this.noParamPayload);
    }

    public void close(AckListener listener) {
        try {
            this.close();
        }
        catch (Exception ex) {
            logger.error("Error close app", (Throwable)ex);
        }
    }

    public void close(Boolean force, AckListener listener) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            if (force != null) {
                payload.put("force", (Object)force);
            }
            payload.put("uuid", (Object)this.getUuid());
            this.connection.sendAction("close-application", payload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error closing application", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void terminate() throws DesktopException {
        this.connection.sendAction("terminate-application", this.noParamPayload);
    }

    public void terminate(AckListener listener) {
        this.connection.sendAction("terminate-application", this.noParamPayload, listener, this);
    }

    public void waitFor() throws DesktopException {
        this.connection.sendAction("wait-for-hung-application", this.noParamPayload);
    }

    public void waitFor(AckListener listener) {
        this.connection.sendAction("wait-for-hung-application", this.noParamPayload, listener, this);
    }

    public void getManifest(AckListener listener) {
        this.connection.sendAction("get-application-manifest", this.noParamPayload, listener, this);
    }

    public Window getWindow() {
        return this.window;
    }

    public ApplicationOptions getOptions() {
        return this.options;
    }

    protected String getUuid() {
        return this.uuid;
    }

    protected DesktopConnection getConnection() {
        return this.connection;
    }

    private void initialize() {
        try {
            this.noParamPayload = new JSONObject();
            this.resizeToPayload = new JSONObject();
            this.resizeByPayload = new JSONObject();
            this.moveToPayload = new JSONObject();
            this.moveByPayload = new JSONObject();
            this.dockWindowPayload = new JSONObject();
            this.noParamPayload.put("uuid", (Object)this.uuid);
            this.resizeToPayload.put("uuid", (Object)this.uuid);
            this.resizeByPayload.put("uuid", (Object)this.uuid);
            this.moveToPayload.put("uuid", (Object)this.uuid);
            this.moveByPayload.put("uuid", (Object)this.uuid);
            this.dockWindowPayload.put("uuid", (Object)this.uuid);
        }
        catch (JSONException e) {
            logger.error("Error initializing application", (Throwable)e);
        }
        this.window = new Window(this);
    }

    private void addEventListener(JSONObject subscriptionObject, EventListener listener, AckListener callback) {
        this.connection.addEventCallback(subscriptionObject, listener, callback, this);
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            logger.debug("addEventListener " + type);
            if (this.eventListenerPayload == null) {
                this.eventListenerPayload = new JSONObject();
                this.eventListenerPayload.put("topic", (Object)"application");
                this.eventListenerPayload.put("uuid", (Object)this.getUuid());
            }
            this.eventListenerPayload.put("type", (Object)type);
            this.addEventListener(this.eventListenerPayload, listener, callback);
        }
        catch (Exception e) {
            logger.error("Error adding event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            logger.debug("removeEventListener " + type);
            if (this.eventListenerPayload == null) {
                this.eventListenerPayload = new JSONObject();
                this.eventListenerPayload.put("topic", (Object)"application");
                this.eventListenerPayload.put("uuid", (Object)this.getUuid());
            }
            this.eventListenerPayload.put("type", (Object)type);
            this.connection.removeEventCallback(this.eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error Removing event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void setTrayIcon(String iconUrl, EventListener listener, AckListener callback) throws DesktopException {
        if (this.trayIconClickListener != null) {
            this.removeEventListener("tray-icon-clicked", this.trayIconClickListener, null);
        }
        this.trayIconClickListener = listener;
        if (listener != null) {
            this.addEventListener("tray-icon-clicked", listener, callback);
        }
        try {
            JSONObject payload = new JSONObject();
            payload.put("uuid", (Object)this.getUuid());
            payload.put("name", (Object)this.getUuid());
            payload.put("enabledIcon", (Object)iconUrl);
            payload.put("disabledIcon", (Object)iconUrl);
            payload.put("hoverIcon", (Object)iconUrl);
            this.connection.sendAction("set-tray-icon", payload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setting tray icon", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void removeTrayIcon(AckListener callback) throws DesktopException {
        if (this.trayIconClickListener != null) {
            this.removeEventListener("tray-icon-clicked", this.trayIconClickListener, null);
            this.trayIconClickListener = null;
        }
        try {
            JSONObject payload = new JSONObject();
            payload.put("uuid", (Object)this.getUuid());
            payload.put("name", (Object)this.getUuid());
            this.connection.sendAction("remove-tray-icon", payload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error removing tray icon", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void createChildWindow(WindowOptions windowOptions, AckListener callback) throws DesktopException {
        try {
            JSONObject payload = new JSONObject();
            payload.put("targetUuid", (Object)this.getUuid());
            payload.put("windowOptions", (Object)windowOptions.getJson());
            this.connection.sendAction("create-child-window", payload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error creating child window", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void getGroups(final AsyncCallback<List<List<Window>>> groupHandler, final AckListener callback) {
        if (groupHandler != null) {
            JSONObject payload = new JSONObject();
            payload.put("uuid", (Object)this.uuid);
            payload.put("crossApp", true);
            this.connection.sendAction("get-application-groups", payload, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    ArrayList list = new ArrayList();
                    try {
                        JSONObject value = ack.getJsonObject();
                        if (value != null) {
                            JSONArray array = value.getJSONArray("data");
                            for (int i = 0; i < array.length(); ++i) {
                                JSONArray subArray = array.getJSONArray(i);
                                if (subArray == null || subArray.length() <= 0) continue;
                                ArrayList<Window> subGroup = new ArrayList<Window>();
                                list.add(subGroup);
                                for (int k = 0; k < subArray.length(); ++k) {
                                    JSONObject item = subArray.getJSONObject(k);
                                    subGroup.add(Window.wrap(item.getString("uuid"), item.getString("windowName"), Application.this.connection));
                                }
                            }
                        }
                        groupHandler.onSuccess(list);
                    }
                    catch (Exception e) {
                        logger.error("Error processing group", (Throwable)e);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(callback, ack);
                }
            }, this);
        }
    }

    public Window wrapWindow(String name) {
        return Window.wrap(this.getUuid(), name, this.connection);
    }
}

