/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopIOException;
import com.openfin.desktop.DesktopStateListener;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.ExternalMessageListener;
import com.openfin.desktop.ExternalMessageResultHandlerFactory;
import com.openfin.desktop.InterApplicationBus;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.NotificationListener;
import com.openfin.desktop.OpenFinRuntime;
import com.openfin.desktop.RuntimeConfiguration;
import com.openfin.desktop.RuntimeLauncher;
import com.openfin.desktop.net.WebSocketConnection;
import com.openfin.desktop.net.WebSocketEventHandler;
import com.openfin.desktop.net.WebSocketException;
import com.openfin.desktop.net.WebSocketMessage;
import com.openfin.desktop.win32.DesktopPortHandler;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopConnection {
    private static final Logger logger = LoggerFactory.getLogger((String)DesktopConnection.class.getName());
    private HashMap<Long, ListenerSourcePair> callbacks;
    private HashMap<Integer, ListenerSourcePair> notificationListenerMap = new HashMap();
    private HashMap<String, HashMap<String, HashMap<String, List<ListenerSourcePair>>>> applicationEventCallbackMap = new HashMap();
    private HashMap<String, HashMap<String, List<ListenerSourcePair>>> systemEventCallbackMap = new HashMap();
    private HashMap<String, HashMap<String, HashMap<String, HashMap<String, List<ListenerSourcePair>>>>> windowEventCallbackMap = new HashMap();
    private List<ExternalMessageListenerSourcePair> externalMessageHandlers = new ArrayList<ExternalMessageListenerSourcePair>();
    private WebSocketConnection websocket;
    private JSONObject jsonMsg;
    private boolean connected = false;
    private String uuid;
    private String host;
    private String path = "";
    private Integer port;
    private int timeout;
    private long waitStartTime;
    boolean opened = false;
    boolean authRequested = false;
    private String authorizationAction;
    private String authorizationType;
    private long messageId = 0L;
    private Integer notificationCount = 1;
    private JSONObject notificationPayload;
    private String runtimeSecurityRealm;
    private List<String> runtimeAppAssets;
    private String additionalRuntimeArguments;
    private String rdmUrl;
    private int devtoolsPort;
    private String runtimeAssetsUrl;
    private String additionalRvmArguments;
    private DesktopStateListener listener;
    private Timer timer;
    private boolean disconnecting = false;
    private InterApplicationBus busInstance;
    private long startTime;
    private long eventTime;
    private long authReqMsgId;
    private EventListener portDiscoveryEventListener;
    private String licenseKey;

    public DesktopConnection(String uuid) throws DesktopException {
        this(uuid, null, null);
    }

    public DesktopConnection(String uuid, String host, Integer port) throws DesktopException {
        if (uuid == null) {
            throw new DesktopException("Invalid uuid: ");
        }
        this.uuid = uuid;
        this.host = host == null ? "127.0.0.1" : host;
        this.port = port;
        this.callbacks = new HashMap();
        this.jsonMsg = new JSONObject();
        this.busInstance = new InterApplicationBus(this);
    }

    private void timingEvent(String event) {
        long now = System.currentTimeMillis();
        double time = (double)(now - this.eventTime) / 1000.0;
        logger.debug("Event:" + event + " secs:" + time);
        this.eventTime = now;
    }

    private void startEvent(String event) {
        long now = System.currentTimeMillis();
        double time = (double)(now - this.startTime) / 1000.0;
        logger.debug("Total Time: " + event + " secs:" + time);
    }

    private void sendRequestAuthorization() throws DesktopException, DesktopIOException {
        if (!this.authRequested) {
            JSONObject json = new JSONObject();
            try {
                json.put("action", (Object)this.authorizationAction);
                JsonUtils.updateValue(json, "action", this.authorizationAction);
                JSONObject client = new JSONObject();
                client.put("type", (Object)"java");
                client.put("version", (Object)(OpenFinRuntime.getAdapterVersion() == null ? "N/A" : OpenFinRuntime.getAdapterVersion()));
                client.put("javaVersion", (Object)System.getProperty("java.version"));
                client.put("pid", (Object)DesktopConnection.getProcessId("N/A"));
                JSONObject payload = new JSONObject();
                payload.put("uuid", (Object)this.uuid);
                payload.put("type", (Object)this.authorizationType);
                payload.put("licenseKey", (Object)(this.licenseKey == null || this.licenseKey.trim().isEmpty() ? "N/A" : this.licenseKey));
                payload.put("client", (Object)client);
                json.put("payload", (Object)payload);
                this.authReqMsgId = this.getNextMessageId();
                json.put("messageId", this.authReqMsgId);
                String msg = json.toString();
                logger.debug("sending message: " + msg);
                if (this.listener != null) {
                    this.listener.onOutgoingMessage(msg);
                }
                this.websocket.send(msg);
            }
            catch (JSONException je) {
                throw new DesktopException((Exception)((Object)je));
            }
            catch (WebSocketException wex) {
                throw new DesktopIOException(wex);
            }
        }
    }

    public void launchAndConnect(String commandLineArguments, DesktopStateListener listener, int timeout) throws URISyntaxException, DesktopIOException {
        this.launchAndConnect(null, commandLineArguments, listener, timeout);
    }

    public void launchAndConnect(String desktopPath, String commandLineArguments, DesktopStateListener listener, int timeout) throws DesktopIOException {
        this.eventTime = this.startTime = System.currentTimeMillis();
        this.listener = listener;
        String string = commandLineArguments = commandLineArguments == null ? "" : commandLineArguments;
        if (desktopPath != null) {
            this.runDesktop(desktopPath, commandLineArguments);
        } else {
            RuntimeLauncher.launchConfig(commandLineArguments);
        }
        this.connect("file-token", listener);
    }

    public void connectToVersion(String runtimeVersion, DesktopStateListener listener, int timeout) throws DesktopIOException, IOException {
        RuntimeConfiguration config = new RuntimeConfiguration();
        config.setRuntimeVersion(runtimeVersion);
        config.setSecurityRealm(this.runtimeSecurityRealm);
        config.setAdditionalRuntimeArguments(this.additionalRuntimeArguments);
        config.setRdmURL(this.rdmUrl);
        config.setRuntimeAssetURL(this.runtimeAssetsUrl);
        config.setAdditionalRvmArguments(this.additionalRvmArguments);
        if (this.devtoolsPort > 0) {
            config.setDevToolsPort(this.devtoolsPort);
        }
        this.connect(config, listener, timeout);
    }

    public void connect(final RuntimeConfiguration configuration, final DesktopStateListener listener, int timeout) throws DesktopIOException, IOException {
        if (this.portDiscoveryEventListener == null) {
            this.eventTime = this.startTime = System.currentTimeMillis();
            this.listener = listener;
            this.port = null;
            this.timeout = timeout;
            this.licenseKey = configuration.getLicenseKey();
            this.portDiscoveryEventListener = new EventListener(){

                @Override
                public void eventReceived(ActionEvent actionEvent) {
                    if (actionEvent.getType().equals("TIMEOUT")) {
                        logger.error("timed out on connectionToVersion");
                        DesktopPortHandler.removeEventListener(DesktopConnection.this.portDiscoveryEventListener);
                        DesktopConnection.this.portDiscoveryEventListener = null;
                        listener.onError("Connection timed out");
                    } else {
                        String requestedSecurityRealm;
                        JSONObject runtimeInfo = actionEvent.getEventObject();
                        Integer port = JsonUtils.getIntegerValue(runtimeInfo, "port", null);
                        String requestedVersion = JsonUtils.getStringValue(runtimeInfo, "requestedVersion", null);
                        if (DesktopConnection.this.matchRuntimeInstance(requestedVersion, requestedSecurityRealm = JsonUtils.getStringValue(runtimeInfo, "securityRealm", null), configuration)) {
                            String runVersion = JsonUtils.getStringValue(runtimeInfo, "version", null);
                            if (port == null) {
                                listener.onError("Port for version " + configuration.getRuntimeVersion() + " not found in COPYDATA");
                            } else if (runVersion == null || runVersion.length() == 0) {
                                listener.onError("Version for version " + configuration.getRuntimeVersion() + " not found in COPYDATA");
                            } else if (DesktopConnection.this.port == null) {
                                DesktopConnection.this.port = port;
                                logger.debug("Runtime version " + runVersion + " at port " + port);
                                try {
                                    DesktopConnection.this.connect(listener);
                                }
                                catch (Exception e) {
                                    logger.error("Error connecing to desktop", (Throwable)e);
                                    listener.onError(e.getMessage());
                                }
                            } else {
                                logger.debug("Port already set at " + DesktopConnection.this.port + ", ignoring " + port);
                            }
                            DesktopPortHandler.removeEventListener(DesktopConnection.this.portDiscoveryEventListener);
                            DesktopConnection.this.portDiscoveryEventListener = null;
                        } else {
                            logger.debug("RequestedVersion " + requestedVersion + " mismatches " + configuration.getRuntimeVersion() + ", ignoring...");
                        }
                    }
                }
            };
            DesktopPortHandler.registerEventListener(this.portDiscoveryEventListener, timeout);
            RuntimeLauncher.launchVersion(configuration);
        } else {
            logger.error("Already waiting to connect to a version");
        }
    }

    private boolean matchRuntimeInstance(String requestedVersion, String securityRealm, RuntimeConfiguration configuration) {
        if (configuration.getRuntimeVersion() != null && configuration.getSecurityRealm() != null && configuration.getRuntimeVersion().equals(requestedVersion) && configuration.getSecurityRealm().equals(securityRealm)) {
            logger.debug("matched Runtime version and security realm");
            return true;
        }
        if (configuration.getRuntimeFallbackVersion() != null && configuration.getSecurityRealm() != null && configuration.getRuntimeFallbackVersion().equals(requestedVersion) && configuration.getSecurityRealm().equals(securityRealm)) {
            logger.debug("matched Runtime fullback version and security realm");
            return true;
        }
        if (configuration.getRuntimeVersion() != null && configuration.getSecurityRealm() == null && configuration.getRuntimeVersion().equals(requestedVersion) && securityRealm == null) {
            logger.debug("matched Runtime version and null security realm");
            return true;
        }
        if (configuration.getRuntimeFallbackVersion() != null && configuration.getSecurityRealm() == null && configuration.getRuntimeFallbackVersion().equals(requestedVersion) && securityRealm == null) {
            logger.debug("matched Runtime fallback version and null security realm");
            return true;
        }
        return false;
    }

    public void disconnect() throws DesktopException {
        this.disconnect(null);
    }

    protected void disconnect(String reason) throws DesktopException {
        this.disconnecting = true;
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.websocket.close(reason);
        }
        catch (WebSocketException e) {
            logger.error("Error disconnecting Runtime", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void exit() throws DesktopException {
        try {
            this.sendAction("exit-desktop", new JSONObject());
        }
        catch (Exception e) {
            logger.error("Error existing Runtime", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public InterApplicationBus getInterApplicationBus() {
        return this.busInstance;
    }

    public Integer getPort() {
        return this.port;
    }

    public void sendAction(String action, JSONObject payload) throws DesktopException {
        this.sendAction(action, payload, null);
    }

    private void sendAction(String action, JSONObject payload, Long newMessageId) throws DesktopException {
        if (this.isConnected()) {
            try {
                this.jsonMsg.put("action", (Object)action);
                if (newMessageId == null) {
                    newMessageId = this.getNextMessageId();
                }
                this.jsonMsg.put("messageId", (Object)newMessageId);
                if (payload != null) {
                    this.jsonMsg.put("payload", (Object)payload);
                } else {
                    this.jsonMsg.remove("payload");
                }
                String msg = this.jsonMsg.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending: " + msg);
                }
                if (this.listener != null) {
                    this.listener.onOutgoingMessage(msg);
                }
                this.websocket.send(msg);
            }
            catch (Exception e) {
                logger.error("Error sending action", (Throwable)e);
                throw new DesktopException(e);
            }
        } else {
            logger.warn("Not connected to sendAction " + this.jsonMsg);
        }
    }

    private synchronized long getNextMessageId() {
        return this.messageId++;
    }

    public void sendAction(String action, JSONObject payload, AckListener listener, Object source) {
        if (this.isConnected()) {
            ListenerSourcePair lsp = new ListenerSourcePair(listener, source);
            Long msgId = null;
            if (listener != null) {
                msgId = this.getNextMessageId();
                this.callbacks.put(msgId, lsp);
            }
            try {
                this.sendAction(action, payload, msgId);
            }
            catch (Exception ex) {
                logger.error("Error sending action", (Throwable)ex);
                DesktopUtils.errorAckOnException(listener, source, ex);
            }
        } else {
            logger.warn("Not connected to sendAction " + action);
        }
    }

    private void runDesktop(final String desktopPath, final String commandLine) throws DesktopIOException {
        logger.debug("run desktop from " + desktopPath + " " + commandLine);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    OutputStream stdin = null;
                    InputStream stderr = null;
                    InputStream stdout = null;
                    Process process = Runtime.getRuntime().exec("cmd");
                    stdin = process.getOutputStream();
                    stderr = process.getErrorStream();
                    stdout = process.getInputStream();
                    String line = "start " + desktopPath + " " + commandLine + "\n";
                    logger.debug(line);
                    stdin.write(line.getBytes());
                    stdin.flush();
                    stdin.close();
                    BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(stdout));
                    while ((line = brCleanUp.readLine()) != null) {
                        logger.debug("[Stdout] " + line);
                    }
                    brCleanUp.close();
                    brCleanUp = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = brCleanUp.readLine()) != null) {
                        logger.debug("[Stderr] " + line);
                    }
                    brCleanUp.close();
                }
                catch (Exception e1) {
                    logger.error("Error starting Runtime", (Throwable)e1);
                }
            }
        };
        thread.setName(this.getClass().getName() + ".runDesktop");
        thread.start();
    }

    public void connect(DesktopStateListener listener) {
        this.connect("file-token", listener);
    }

    private void connect(String type, final DesktopStateListener listener) {
        if (this.connected) {
            listener.onError("Desktop websocket already connected");
            return;
        }
        this.authorizationAction = "request-external-authorization";
        this.authorizationType = type;
        this.authRequested = false;
        try {
            if (this.host == null || this.path == null) {
                throw new WebSocketException("");
            }
            URI uri = new URI("ws://" + this.host + ":" + this.port + "/" + this.path);
            logger.debug("opening websocket " + uri.toString());
            this.websocket = new WebSocketConnection(uri);
        }
        catch (Exception ex) {
            logger.error("Error connecting to Runtime", (Throwable)ex);
            listener.onError(ex.getMessage());
        }
        this.websocket.setEventHandler(new WebSocketEventHandler(){

            @Override
            public void onOpen() {
                try {
                    DesktopConnection.this.timingEvent("onOpen");
                    DesktopConnection.this.disconnecting = false;
                    DesktopConnection.this.opened = true;
                    DesktopConnection.this.cancelConnectWaitTimer();
                    DesktopConnection.this.sendRequestAuthorization();
                }
                catch (Exception authEx) {
                    logger.error("Error onOpen", (Throwable)authEx);
                    listener.onError(authEx.getMessage());
                }
            }

            @Override
            public void onMessage(WebSocketMessage message) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received message: " + message.getText());
                }
                listener.onMessage(message.getText());
                try {
                    JSONObject json = new JSONObject(message.getText());
                    String action = json.getString("action");
                    JSONObject payload = json.getJSONObject("payload");
                    DesktopConnection.this.timingEvent("action:" + action);
                    if (action.equals("ack")) {
                        logger.debug("Receiving Ack: " + message.getText());
                        if (json.has("correlationId")) {
                            long correlationId = json.getLong("correlationId");
                            if (correlationId == DesktopConnection.this.authReqMsgId) {
                                boolean authDone = payload.getBoolean("success");
                                if (!authDone) {
                                    logger.debug("retry sendRequestAuthorization");
                                    try {
                                        DesktopConnection.this.sendRequestAuthorization();
                                    }
                                    catch (Exception authEx) {
                                        logger.error("Error sending auth request", (Throwable)authEx);
                                        listener.onError(authEx.getMessage());
                                    }
                                }
                            } else {
                                DesktopConnection.this.fireMessageCallback(correlationId, payload);
                            }
                        }
                    } else if (action.equals("external-authorization-response")) {
                        try {
                            DesktopConnection.this.processExternalAuthorizationResponse(payload);
                        }
                        catch (Exception authEx) {
                            logger.error("Error processing auth request", (Throwable)authEx);
                            listener.onError(authEx.getMessage());
                        }
                    } else if (action.equals("authorization-response")) {
                        DesktopConnection.this.authRequested = true;
                        boolean success = payload.getBoolean("success");
                        if (success) {
                            DesktopConnection.this.connected = true;
                            listener.onReady();
                            DesktopConnection.this.startEvent("Connected");
                        } else if (!DesktopConnection.this.disconnecting) {
                            String reason = payload.getString("reason");
                            try {
                                listener.onError(reason);
                                DesktopConnection.this.disconnect("Authorization request to Runtime is denied");
                            }
                            catch (Exception ex) {
                                logger.error("Error processing auth response");
                            }
                        }
                    } else if (action.equals("process-message")) {
                        String sourceUuid = payload.getString("sourceUuid");
                        String topic = payload.getString("topic");
                        DesktopConnection.this.busInstance.dispatchMessageToCallbacks(sourceUuid, topic, payload.get("message"));
                        if ("utils-ready".equals(topic)) {
                            DesktopConnection.this.startEvent("AdminReady");
                        }
                    } else if (action.equals("process-notification-event")) {
                        DesktopConnection.this.processNotificationEvent(payload);
                    } else if (action.equals("process-desktop-event")) {
                        DesktopConnection.this.dispatchDesktopEvent(payload);
                    } else if (action.equals("subscriber-added")) {
                        DesktopConnection.this.busInstance.dispatchToSubscribeListeners(payload.getString("uuid"), payload.getString("topic"));
                    } else if (action.equals("subscriber-removed")) {
                        DesktopConnection.this.busInstance.dispatchToUnsubscribeListeners(payload.getString("uuid"), payload.getString("topic"));
                    } else if (!action.equals("process-external-app-action")) {
                        if (action.equals("ping")) {
                            long pingId = payload.getLong("pingId");
                            DesktopConnection.this.respondToPing(pingId);
                        } else if (action.equals("process-external-message")) {
                            DesktopConnection.this.processExternalMessage(payload);
                        } else if (action.equals("app-connected")) {
                            DesktopConnection.this.processWindowConnected(payload);
                        } else if (action.equals("app-loaded")) {
                            DesktopConnection.this.processWindowLoaded(payload);
                        }
                    }
                }
                catch (JSONException e) {
                    logger.error("Error processing message from Runtime", (Throwable)e);
                    listener.onError(e.getMessage());
                }
            }

            @Override
            public void onClose() {
                logger.debug("onClose");
                DesktopConnection.this.connected = false;
                DesktopConnection.this.opened = false;
                DesktopConnection.this.cancelConnectWaitTimer();
                listener.onClose();
                DesktopConnection.this.disconnecting = false;
            }
        });
        this.startConnectWaitTimer(new TimerTask(){

            @Override
            public void run() {
                if (DesktopConnection.this.websocket.isConnected()) {
                    logger.debug("connectToDesktop-timer-stopped connected");
                    DesktopConnection.this.timer.cancel();
                } else if (DesktopConnection.this.authRequested) {
                    logger.debug("connectToDesktop-timer-stopped auth received");
                    DesktopConnection.this.timer.cancel();
                } else if (!DesktopConnection.this.opened) {
                    try {
                        logger.debug("Trying to connect to Runtime");
                        DesktopConnection.this.websocket.connect();
                    }
                    catch (WebSocketException e) {
                        logger.error("Failed to connect to Runtime", (Throwable)e);
                    }
                }
                if (DesktopConnection.this.checkConnectTimeout()) {
                    DesktopConnection.this.cancelConnectWaitTimer();
                    listener.onError("Connection timed out");
                }
            }
        });
    }

    private void startConnectWaitTimer(TimerTask timerTask) {
        this.cancelConnectWaitTimer();
        this.waitStartTime = System.currentTimeMillis();
        this.timer = new Timer(String.format("ConnectWaitTimer-%s", this.uuid));
        logger.debug("connectToDesktop-timer-start " + this.uuid);
        this.timer.schedule(timerTask, 0L, 100L);
    }

    private void cancelConnectWaitTimer() {
        if (this.timer != null) {
            logger.debug("connectToDesktop-timer-stopped " + this.uuid);
            this.timer.cancel();
        }
    }

    private boolean checkConnectTimeout() {
        int secs = (int)((System.currentTimeMillis() - this.waitStartTime) / 1000L);
        if (secs > this.timeout) {
            logger.debug("checkConnectTimeout true " + this.uuid);
            return true;
        }
        return false;
    }

    private void fireMessageCallback(long correlationId, JSONObject payload) {
        ListenerSourcePair lsp = this.callbacks.remove(correlationId);
        if (lsp != null) {
            Object source = lsp.getSource();
            AckListener ackListener = lsp.getListener();
            Ack ack = new Ack(payload, source);
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(ackListener, ack);
            } else {
                DesktopUtils.errorAck(ackListener, ack);
            }
        }
    }

    private void processExternalAuthorizationResponse(JSONObject payload) throws JSONException, IOException, WebSocketException {
        if (this.authorizationType.equals("file-token")) {
            String token = payload.getString("token");
            String file = payload.getString("file");
            if (token != null && file != null && file.length() > 0 && token.length() > 0) {
                FileWriter writer = new FileWriter(file);
                writer.write(token);
                writer.close();
            }
        }
        this.sendFinalAuthorizationRequest(this.authorizationType);
    }

    private void sendFinalAuthorizationRequest(String type) throws JSONException, WebSocketException {
        this.disconnecting = false;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"request-authorization");
        JSONObject payload = new JSONObject();
        payload.put("uuid", (Object)this.uuid);
        payload.put("type", (Object)type);
        json.put("payload", (Object)payload);
        String msg = json.toString();
        if (this.listener != null) {
            this.listener.onOutgoingMessage(msg);
        }
        this.websocket.send(msg);
    }

    private void processNotificationEvent(JSONObject payload) {
        Integer notificationId;
        if (payload != null && (notificationId = this.getNestedJSONInteger(payload, "payload.notificationId")) != null) {
            try {
                ListenerSourcePair lsp = this.notificationListenerMap.get(notificationId);
                if (lsp != null) {
                    String type = payload.getString("type");
                    if (lsp.getNotificationListener() != null) {
                        this.invokeNotificationCallback(lsp.getNotificationListener(), new Ack(payload, lsp.getSource()), type);
                    }
                    if (type == "close" || type == "error" || type == "dismiss") {
                        this.notificationListenerMap.remove(notificationId);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error processing notification event", (Throwable)e);
            }
        }
    }

    private void invokeNotificationCallback(NotificationListener listener, Ack ack, String type) {
        String methodName = "on" + type.substring(0, 1).toUpperCase() + type.substring(1);
        try {
            Method method = listener.getClass().getMethod(methodName, ack.getClass());
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)listener, ack);
            }
        }
        catch (Exception e) {
            logger.error("Error invoking notification callback", (Throwable)e);
        }
    }

    public Integer registerNotificationListener(NotificationListener listener, Object source) {
        Integer returnId = 0;
        if (listener != null) {
            this.notificationListenerMap.put(this.notificationCount, new ListenerSourcePair(listener, source));
            Integer n = this.notificationCount;
            Integer n2 = this.notificationCount = Integer.valueOf(this.notificationCount + 1);
            returnId = n;
        }
        return returnId;
    }

    public void sendActionToNotificationsCenter(String action, JSONObject payload, AckListener callback, Object source) {
        try {
            if (this.notificationPayload == null) {
                this.notificationPayload = new JSONObject();
            }
            this.notificationPayload.put("action", (Object)action);
            this.notificationPayload.put("payload", (Object)payload);
            this.sendAction("send-action-to-notifications-center", this.notificationPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error sending message to notification center", (Throwable)e);
            DesktopUtils.errorAckOnException(callback, payload, e);
        }
    }

    private Integer getNestedJSONInteger(JSONObject json, String expression) {
        Integer result = null;
        StringTokenizer tokenizer = new StringTokenizer(expression, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        JSONObject nested = json;
        try {
            for (int i = 0; i < list.size() - 1; ++i) {
                if (!nested.has((String)list.get(i))) {
                    nested = null;
                    break;
                }
                nested = nested.getJSONObject((String)list.get(i));
            }
            if (nested != null) {
                result = nested.getInt((String)list.get(list.size() - 1));
            }
        }
        catch (Exception e) {
            logger.error("Error reading integer from JSON", (Throwable)e);
        }
        return result;
    }

    private List<ListenerSourcePair> getEventCallbackList(JSONObject subscriptionObject) {
        List<ListenerSourcePair> list = null;
        try {
            String topic = subscriptionObject.getString("topic");
            String type = this.getFullEventType(topic, subscriptionObject.getString("type"));
            String uuid = JsonUtils.getStringValue(subscriptionObject, "uuid", null);
            String name = null;
            if (subscriptionObject.has("name")) {
                name = subscriptionObject.getString("name");
            }
            list = this.getEventCallbackList(topic, type, uuid, name);
        }
        catch (Exception e) {
            logger.error("Error getting event callback list", (Throwable)e);
        }
        return list;
    }

    private List<ListenerSourcePair> getEventCallbackList(String topic, String type, String uuid, String name) {
        List<ListenerSourcePair> callbacks = null;
        if (topic != null && type != null) {
            if (topic.equals("application")) {
                if (uuid != null) {
                    HashMap<String, List<ListenerSourcePair>> matchedType;
                    HashMap<String, HashMap<String, List<ListenerSourcePair>>> matchedTopic = this.applicationEventCallbackMap.get(topic);
                    if (matchedTopic == null) {
                        matchedTopic = new HashMap();
                        this.applicationEventCallbackMap.put(topic, matchedTopic);
                    }
                    if ((matchedType = matchedTopic.get(type)) == null) {
                        matchedType = new HashMap();
                        matchedTopic.put(type, matchedType);
                    }
                    if ((callbacks = matchedType.get(uuid)) == null) {
                        callbacks = new ArrayList<ListenerSourcePair>();
                        matchedType.put(uuid, callbacks);
                    }
                }
            } else if (topic.equals("system")) {
                HashMap<String, List<ListenerSourcePair>> matchedTopic = this.systemEventCallbackMap.get(topic);
                if (matchedTopic == null) {
                    matchedTopic = new HashMap();
                    this.systemEventCallbackMap.put(topic, matchedTopic);
                }
                if ((callbacks = matchedTopic.get(type)) == null) {
                    callbacks = new ArrayList<ListenerSourcePair>();
                    matchedTopic.put(type, callbacks);
                }
            } else if (topic.equals("window")) {
                if (uuid != null && name != null) {
                    HashMap<String, List<ListenerSourcePair>> matchedUuid;
                    HashMap<String, HashMap<String, List<ListenerSourcePair>>> matchedType;
                    HashMap<String, HashMap<String, HashMap<String, List<ListenerSourcePair>>>> matchedTopic = this.windowEventCallbackMap.get(topic);
                    if (matchedTopic == null) {
                        matchedTopic = new HashMap();
                        this.windowEventCallbackMap.put(topic, matchedTopic);
                    }
                    if ((matchedType = matchedTopic.get(type)) == null) {
                        matchedType = new HashMap();
                        matchedTopic.put(type, matchedType);
                    }
                    if ((matchedUuid = matchedType.get(uuid)) == null) {
                        matchedUuid = new HashMap();
                        matchedType.put(uuid, matchedUuid);
                    }
                    if ((callbacks = matchedUuid.get(name)) == null) {
                        callbacks = new ArrayList<ListenerSourcePair>();
                        matchedUuid.put(name, callbacks);
                    }
                }
            } else {
                callbacks = null;
            }
        }
        return callbacks;
    }

    private String getFullEventType(String topic, String type) {
        String fullType = topic.equals("application") ? (type.indexOf("application-") == -1 ? "application-" + type : type) : (topic.equals("system") ? type : (topic.equals("window") ? (type.indexOf("window-") == -1 ? "window-" + type : type) : type));
        return fullType;
    }

    public void addEventCallback(JSONObject subscriptionObject, EventListener listener, AckListener callback, Object source) {
        List<ListenerSourcePair> callbacks = this.getEventCallbackList(subscriptionObject);
        if (callbacks != null) {
            if (callbacks.size() == 0) {
                String topic = subscriptionObject.getString("topic");
                String type = subscriptionObject.getString("type");
                if (topic.equals("window") && type.equals("app-connected")) {
                    JSONObject notifyConnected = new JSONObject();
                    notifyConnected.put("targetUuid", (Object)subscriptionObject.getString("uuid"));
                    notifyConnected.put("name", (Object)subscriptionObject.getString("name"));
                    this.sendAction("notify-on-app-connected", notifyConnected, callback, source);
                } else if (topic.equals("window") && type.equals("app-loaded")) {
                    JSONObject notifyConnected = new JSONObject();
                    notifyConnected.put("targetUuid", (Object)subscriptionObject.getString("uuid"));
                    notifyConnected.put("name", (Object)subscriptionObject.getString("name"));
                    this.sendAction("notify-on-content-loaded", notifyConnected, callback, source);
                } else {
                    this.sendAction("subscribe-to-desktop-event", subscriptionObject, callback, source);
                }
            }
            try {
                callbacks.add(new ListenerSourcePair(listener, subscriptionObject.getString("type"), source));
                if (callbacks.size() > 1 && callback != null) {
                    JSONObject payload = new JSONObject();
                    payload.put("success", true);
                    DesktopUtils.successAck(callback, new Ack(payload, source));
                }
            }
            catch (Exception e) {
                logger.error("Error adding event callback", (Throwable)e);
            }
        }
    }

    public void removeEventCallback(JSONObject subscriptionObject, EventListener listener, AckListener callback, Object source) {
        List<ListenerSourcePair> callbacks = this.getEventCallbackList(subscriptionObject);
        if (callbacks != null) {
            this.removeFromListenerSourcePairList(callbacks, listener, source);
            if (callbacks.size() == 0) {
                String topic = subscriptionObject.getString("topic");
                String type = subscriptionObject.getString("type");
                if (!(topic.equals("window") && type.equals("app-connected") || topic.equals("window") && type.equals("app-loaded"))) {
                    this.sendAction("unsubscribe-to-desktop-event", subscriptionObject, callback, source);
                }
            }
        }
    }

    private void removeFromListenerSourcePairList(List<ListenerSourcePair> list, EventListener listener, Object source) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ListenerSourcePair lsp = list.get(i);
                if (lsp.getEventListener() != listener || lsp.getSource() != source) continue;
                list.remove(i);
                break;
            }
        }
    }

    private void dispatchDesktopEvent(JSONObject payload) {
        List<ListenerSourcePair> callbacks = this.getEventCallbackList(payload);
        if (callbacks != null) {
            for (ListenerSourcePair lsp : callbacks) {
                lsp.getEventListener().eventReceived(new ActionEvent(lsp.getType(), payload, lsp.getSource()));
            }
        }
    }

    protected void respondToPing(long pingId) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("correlationId", pingId);
            this.sendAction("pong", payload);
        }
        catch (Exception e) {
            logger.error("Error responding to ping", (Throwable)e);
        }
    }

    public void addExternalMessageHandler(ExternalMessageListener listener, Object source) {
        this.externalMessageHandlers.add(new ExternalMessageListenerSourcePair(listener, source));
    }

    private void processExternalMessage(JSONObject payload) {
        ExternalMessageResultHandlerFactory messageHandlerFactory = new ExternalMessageResultHandlerFactory(this.uuid, this, payload);
        for (ExternalMessageListenerSourcePair pair : this.externalMessageHandlers) {
            pair.handler.process(messageHandlerFactory.makeResultHandler(), payload);
        }
        messageHandlerFactory.allDispatched();
    }

    private void processWindowConnected(JSONObject payload) {
        String uuid = payload.getString("uuid");
        String appUuid = payload.getString("appUuid");
        String name = payload.getString("name");
        String topic = "window";
        String type = this.getFullEventType(topic, "app-connected");
        List<ListenerSourcePair> list = this.getEventCallbackList(topic, type, appUuid, name);
        if (list != null) {
            for (ListenerSourcePair pair : list) {
                pair.getEventListener().eventReceived(new ActionEvent(pair.getType(), payload, pair.getSource()));
            }
        }
    }

    private void processWindowLoaded(JSONObject payload) {
        String uuid = payload.getString("uuid");
        String appUuid = payload.getString("appUuid");
        String name = payload.getString("name");
        String topic = "window";
        String type = this.getFullEventType(topic, "app-loaded");
        List<ListenerSourcePair> list = this.getEventCallbackList(topic, type, appUuid, name);
        if (list != null) {
            for (ListenerSourcePair pair : list) {
                pair.getEventListener().eventReceived(new ActionEvent(pair.getType(), payload, pair.getSource()));
            }
        }
    }

    public void setAdditionalRuntimeArguments(String additionalRuntimeArguments) {
        this.additionalRuntimeArguments = additionalRuntimeArguments;
    }

    public void setAdditionalRvmArguments(String additionalRvmArguments) {
        this.additionalRvmArguments = additionalRvmArguments;
    }

    public void setRuntimeSecurityRealm(String runtimeSecurityRealm) {
        this.runtimeSecurityRealm = runtimeSecurityRealm;
    }

    public void setRdmUrl(String url) {
        this.rdmUrl = url;
    }

    public void setDevToolsPort(int port) {
        this.devtoolsPort = port;
    }

    public void setRuntimeAssetsUrl(String url) {
        this.runtimeAssetsUrl = url;
    }

    public void addAppAsset(String config) {
        if (this.runtimeAppAssets == null) {
            this.runtimeAppAssets = new ArrayList<String>();
        }
        this.runtimeAppAssets.add(config);
    }

    public void setLogLevel(boolean enabled) {
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    private static class ExternalMessageListenerSourcePair {
        private ExternalMessageListener handler;
        private Object source;

        public ExternalMessageListenerSourcePair(ExternalMessageListener handler, Object source) {
            this.handler = handler;
            this.source = source;
        }
    }

    private static class ListenerSourcePair {
        private AckListener listener;
        private EventListener eventListener;
        private NotificationListener notificationListener;
        private Object source;
        private String type;

        ListenerSourcePair(AckListener listener, Object source) {
            this.listener = listener;
            this.source = source;
        }

        ListenerSourcePair(NotificationListener listener, Object source) {
            this.notificationListener = listener;
            this.source = source;
        }

        ListenerSourcePair(EventListener listener, String eventType, Object source) {
            this.eventListener = listener;
            this.type = eventType;
            this.source = source;
        }

        Object getSource() {
            return this.source;
        }

        AckListener getListener() {
            return this.listener;
        }

        NotificationListener getNotificationListener() {
            return this.notificationListener;
        }

        EventListener getEventListener() {
            return this.eventListener;
        }

        String getType() {
            return this.type;
        }
    }
}

