/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.AckListener;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.NotificationListener;
import com.openfin.desktop.NotificationOptions;
import org.json.JSONObject;

public class Notification {
    private DesktopConnection desktopConnection;
    private Integer id = 0;
    private JSONObject closePayload;
    private JSONObject sendMessagePayload;

    public Notification(NotificationOptions notificationOptions, NotificationListener notificationListener, DesktopConnection desktopConnection, AckListener listener) throws Exception {
        this.desktopConnection = desktopConnection;
        if (notificationOptions != null && notificationListener != null) {
            this.id = desktopConnection.registerNotificationListener(notificationListener, this);
            if (this.id > 0) {
                JSONObject payload = new JSONObject();
                JsonUtils.updateValue(payload, "url", notificationOptions.getURL());
                JsonUtils.updateValue(payload, "notificationId", this.id);
                if (notificationOptions.getMessage() != null) {
                    JsonUtils.updateValue(payload, "message", notificationOptions.getMessage());
                } else {
                    JsonUtils.updateValue(payload, "message", notificationOptions.getMessageText());
                }
                if (notificationOptions.getTimeout() > -1) {
                    JsonUtils.updateValue(payload, "timeout", notificationOptions.getTimeout());
                } else {
                    JsonUtils.updateValue(payload, "timeout", "never");
                }
                this.desktopConnection.sendActionToNotificationsCenter("create-notification", payload, listener, this);
            }
        }
    }

    public void close(AckListener listener) {
        try {
            if (this.closePayload == null) {
                this.closePayload = new JSONObject();
                JsonUtils.updateValue(this.closePayload, "notificationId", this.id);
            }
            this.desktopConnection.sendActionToNotificationsCenter("close-notification", this.closePayload, listener, this);
        }
        catch (Exception ex) {
            DesktopUtils.errorAckOnException(listener, this, ex);
        }
    }

    public void sendMessage(JSONObject message, AckListener listener) {
        this.generateNotificationMessage("send-notification-message", message, listener);
    }

    public void sendMessage(String message, AckListener listener) {
        this.generateNotificationMessage("send-notification-message", message, listener);
    }

    private void generateNotificationMessage(String action, Object message, AckListener listener) {
        try {
            if (this.sendMessagePayload == null) {
                this.sendMessagePayload = new JSONObject();
                JsonUtils.updateValue(this.sendMessagePayload, "notificationId", this.id);
            }
            if (message instanceof String) {
                JsonUtils.updateValue(this.sendMessagePayload, "message", (String)message);
            } else {
                JsonUtils.updateValue(this.sendMessagePayload, "message", (JSONObject)message);
            }
            this.desktopConnection.sendActionToNotificationsCenter(action, this.sendMessagePayload, listener, this);
        }
        catch (Exception ex) {
            DesktopUtils.errorAckOnException(listener, this, ex);
        }
    }
}

