/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.animation;

import com.openfin.desktop.animation.AbstractAnimation;
import com.openfin.desktop.animation.OpacityTransition;
import com.openfin.desktop.animation.PositionTransition;
import com.openfin.desktop.animation.SizeTransition;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationTransitions {
    private static final Logger logger = LoggerFactory.getLogger((String)AnimationTransitions.class.getName());
    private OpacityTransition opacity;
    private SizeTransition size;
    private PositionTransition position;

    private boolean isTransitionEmpty(AbstractAnimation transition) {
        return transition == null || transition.toJsonObject().length() == 0;
    }

    public JSONObject toJsonObject() {
        JSONObject container = new JSONObject();
        try {
            if (!this.isTransitionEmpty(this.opacity)) {
                container.put("opacity", (Object)this.opacity.toJsonObject());
            }
            if (!this.isTransitionEmpty(this.size)) {
                container.put("size", (Object)this.size.toJsonObject());
            }
            if (!this.isTransitionEmpty(this.position)) {
                container.put("position", (Object)this.position.toJsonObject());
            }
        }
        catch (Exception e) {
            logger.error("Error toJSONObject", (Throwable)e);
        }
        return container;
    }

    public OpacityTransition getOpacity() {
        return this.opacity;
    }

    public void setOpacity(OpacityTransition opacity) {
        this.opacity = opacity;
    }

    public SizeTransition getSize() {
        return this.size;
    }

    public void setSize(SizeTransition size) {
        this.size = size;
    }

    public PositionTransition getPosition() {
        return this.position;
    }

    public void setPosition(PositionTransition position) {
        this.position = position;
    }
}

