/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.net;

import com.openfin.desktop.net.WebSocketEventHandler;
import com.openfin.desktop.net.WebSocketException;
import com.openfin.desktop.net.WebSocketMessage;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection {
    private static Logger logger = LoggerFactory.getLogger((String)WebSocketConnection.class.getName());
    private URI url = null;
    private WebSocketEventHandler eventHandler = null;
    private WebSocket.Connection connection;

    public WebSocketConnection(URI url) throws WebSocketException {
        this.url = url;
    }

    public void setEventHandler(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public WebSocketEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen();
    }

    public void connect() throws WebSocketException {
        try {
            if (this.connection != null) {
                throw new WebSocketException("already connected");
            }
            WebSocketClientFactory factory = new WebSocketClientFactory();
            factory.start();
            final WebSocketClient client = factory.newWebSocketClient();
            client.open(this.url, (WebSocket)new WebSocket.OnTextMessage(){

                public void onOpen(WebSocket.Connection connection) {
                    WebSocketConnection.this.connection = connection;
                    connection.setMaxIdleTime(0);
                    connection.setMaxTextMessageSize(65536);
                    logger.debug(String.format("Connected: %s timeout: %d", client.getBindAddress(), connection.getMaxIdleTime()));
                    WebSocketConnection.this.eventHandler.onOpen();
                }

                public void onClose(int closeCode, String message) {
                    logger.debug(String.format("Connection closed: %d - %s", closeCode, message));
                    WebSocketConnection.this.connection = null;
                    try {
                        WebSocketConnection.this.eventHandler.onClose();
                    }
                    catch (Exception ex) {
                        logger.error("Error processing close event", (Throwable)ex);
                    }
                }

                public void onMessage(String data) {
                    WebSocketConnection.this.eventHandler.onMessage(new WebSocketMessage(data));
                }
            }).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new WebSocketException("InterruptedException:" + e.getMessage());
        }
        catch (ExecutionException e) {
            throw new WebSocketException("ExecutionException:" + e.getMessage());
        }
        catch (TimeoutException e) {
            throw new WebSocketException("TimeoutException:" + e.getMessage());
        }
        catch (IOException e) {
            throw new WebSocketException("IOException:" + e.getMessage());
        }
        catch (Exception e) {
            throw new WebSocketException("Exception:" + e.getMessage());
        }
    }

    public synchronized void send(String data) throws WebSocketException {
        if (this.connection == null) {
            throw new WebSocketException("error while sending text data: not connected");
        }
        try {
            this.connection.sendMessage(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() throws WebSocketException {
        this.close("Requested by OpenFin app");
    }

    public synchronized void close(String reason) throws WebSocketException {
        if (this.connection == null) {
            return;
        }
        try {
            logger.debug(String.format("close %s", reason));
            this.connection.close(1000, reason);
        }
        catch (Exception ex) {
            logger.error("Error closing session", (Throwable)ex);
        }
    }
}

