/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.win32.WindowProcCallback;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinMessageHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)WinMessageHelper.class.getName());
    public static CustomUser32 customUser32;
    private static Map<WinDef.HWND, HookProcInfo> callbackMap;

    public static void hookWndProc(WinDef.HWND hwnd, WindowProcCallback callback) {
        Pointer prev;
        logger.debug("hookWndProc" + hwnd);
        CustomWindowProc customWindowProc = new CustomWindowProc(){

            @Override
            public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, Pointer lParam) {
                logger.debug("callback uMsg " + uMsg);
                HookProcInfo hpi = (HookProcInfo)callbackMap.get(hwnd);
                if (hpi != null) {
                    boolean handled = hpi.winProcCallback.callback(hwnd, uMsg, wParam, lParam);
                    if (!handled) {
                        return customUser32.CallWindowProc(hpi.prevWndProc, hwnd, uMsg, wParam, lParam);
                    }
                    logger.debug("uMsg handled " + uMsg);
                    return new WinDef.LRESULT(1L);
                }
                logger.debug("custom windowproc missing. calling default");
                return customUser32.DefWindowProc(hwnd, uMsg, wParam, lParam);
            }
        };
        if (Platform.is64Bit()) {
            logger.debug("installing 64b WNDPROC " + customWindowProc);
            prev = customUser32.SetWindowLongPtr(hwnd, -4, customWindowProc);
        } else {
            logger.debug("installing WNDPROC " + customWindowProc);
            prev = customUser32.SetWindowLong(hwnd, -4, customWindowProc);
        }
        logger.debug("saving WNDPROC " + prev);
        HookProcInfo info = new HookProcInfo();
        info.hwnd = hwnd;
        info.prevWndProc = prev;
        info.winProcCallback = callback;
        info.customWindowProc = customWindowProc;
        callbackMap.put(hwnd, info);
    }

    public static void unhookWndProc(WinDef.HWND hwnd) {
        logger.debug("unhookWndProc" + hwnd);
        HookProcInfo hpi = callbackMap.get(hwnd);
        if (hpi != null) {
            if (Platform.is64Bit()) {
                logger.debug("installing 64b WNDPROC " + hpi.prevWndProc);
                User32.INSTANCE.SetWindowLongPtr(hwnd, -4, hpi.prevWndProc);
            } else {
                logger.debug("installing WNDPROC " + hpi.prevWndProc);
                customUser32.SetWindowLong(hwnd, -4, hpi.prevWndProc);
            }
            callbackMap.remove(hwnd);
        }
    }

    public static void embedInto(long parentHwndId, long childHwndId, int width, int height, AckListener callback) {
        block3: {
            logger.debug("embedInto" + parentHwndId);
            try {
                Pointer p = Pointer.createConstant((long)childHwndId);
                WinDef.HWND childHwnd = new WinDef.HWND(p);
                WinDef.HWND parentHwnd = new WinDef.HWND(new Pointer(parentHwndId));
                logger.debug("SetParent " + childHwnd + " to " + parentHwnd);
                WinDef.HWND prevParent = User32.INSTANCE.SetParent(childHwnd, parentHwnd);
                logger.debug("SetWindowLong " + childHwnd + " to " + parentHwnd);
                User32.INSTANCE.SetWindowLong(childHwnd, -8, (int)parentHwndId);
                int style = User32.INSTANCE.GetWindowLong(childHwnd, -16);
                style &= Integer.MAX_VALUE;
                User32.INSTANCE.SetWindowLong(childHwnd, -16, style |= 0x40000000);
                logger.debug("MoveWindow  (" + width + "," + height + ")");
                User32.INSTANCE.MoveWindow(childHwnd, 0, 0, width, height, true);
                if (callback != null) {
                    JSONObject msg = new JSONObject();
                    msg.put("success", (Object)Boolean.TRUE);
                    msg.put("hWndPreviousParent", Pointer.nativeValue((Pointer)prevParent.getPointer()));
                    DesktopUtils.successAck(callback, new Ack(msg, childHwnd));
                }
            }
            catch (Exception e) {
                logger.error("Error embedding window", (Throwable)e);
                if (callback == null) break block3;
                JSONObject msg = new JSONObject();
                msg.put("success", (Object)Boolean.FALSE);
                DesktopUtils.errorAck(callback, new Ack(msg, childHwndId));
            }
        }
    }

    public static void embededViewSizeChange(long parentHwndId, long childHwndId, int width, int height) {
        logger.debug("MoveWindow  (" + width + "," + height + ")");
        Pointer p = Pointer.createConstant((long)childHwndId);
        WinDef.HWND childHwnd = new WinDef.HWND(p);
        User32.INSTANCE.MoveWindow(childHwnd, 0, 0, width, height, true);
    }

    public static String registryUserGetStringValue(String key, String valueName) {
        String value = null;
        try {
            value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)valueName);
        }
        catch (Exception ex) {
            logger.debug(String.format("Error reading registry %s %s", key, valueName), (Throwable)ex);
        }
        return value;
    }

    public static void main(String[] argv) {
        try {
            String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor";
            String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor");
            String processorId = processorIds[0];
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorId;
            System.out.println(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString").trim());
            String settings = "SOFTWARE\\OpenFin\\RVM\\Settings";
            System.out.println(Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)settings, (String)"cleanUnusedRuntimes"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        callbackMap = Collections.synchronizedMap(new HashMap());
        try {
            customUser32 = (CustomUser32)Native.loadLibrary((String)"user32", CustomUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        }
        catch (Exception e) {
            logger.error("Error initializing user32 lib", (Throwable)e);
        }
    }

    private static class HookProcInfo {
        public WinDef.HWND hwnd;
        public Pointer prevWndProc;
        public WindowProcCallback winProcCallback;
        public CustomWindowProc customWindowProc;

        private HookProcInfo() {
        }
    }

    public static interface CustomUser32
    extends StdCallLibrary {
        public static final int GWL_HWNDPARENT = -8;

        public Pointer SetWindowLong(WinDef.HWND var1, int var2, CustomWindowProc var3);

        public Pointer SetWindowLong(WinDef.HWND var1, int var2, Pointer var3);

        public Pointer SetWindowLongPtr(WinDef.HWND var1, int var2, CustomWindowProc var3);

        public WinDef.LRESULT CallWindowProc(Pointer var1, WinDef.HWND var2, int var3, WinDef.WPARAM var4, Pointer var5);

        public WinDef.LRESULT DefWindowProc(WinDef.HWND var1, int var2, WinDef.WPARAM var3, Pointer var4);

        public boolean GetCursorPos(WinDef.POINT var1);

        public boolean ChangeWindowMessageFilterEx(WinDef.HWND var1, int var2, WinDef.DWORD var3, Pointer var4);
    }

    private static interface CustomWindowProc
    extends Callback {
        public WinDef.LRESULT callback(WinDef.HWND var1, int var2, WinDef.WPARAM var3, Pointer var4);
    }
}

