/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.jooq;

import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SimpleSuspendableClassifier;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;

public class JooqClassifier
implements SuspendableClassifier {
    private static final String PKG_PREFIX = "org/jooq";
    String[][] methodsArray = new String[][]{{"java/util/Iterator", "hasNext"}, {"java/sql/Statement", ".*"}, {"java/sql/Connection", ".*"}, {"org/jooq/Context", "visit", "bindValue"}, {"org/jooq/Binding", "register", "get", "set"}, {"org/jooq/QueryPartInternal", "accept", "bind"}, {"org/jooq/BindContext", "bind", "bindValue", "bindValues"}, {"org/jooq/Query", "execute"}, {"org/jooq/ResultQuery", "getResult", "fetch.*"}, {"org/jooq/Cursor", "fetch.*", "hasNext"}, {"org/jooq/InsertResultStep", "fetch.*"}, {"org/jooq/impl/RecordOperation", "operate"}, {"org/jooq/impl/AbstractField", "accept"}, {"org/jooq/impl/AbstractQuery", "prepare"}, {"org/jooq/impl/AbstractContext", "visit0"}, {"org/jooq/impl/AbstractBindContext", "bindValue0", "bindInternal"}, {"org/jooq/impl/AbstractStoreQuery", "accept0"}, {"org/jooq/impl/AbstractDMLQuery", "accept0"}, {"org/jooq/impl/AbstractResultQuery", "getFields"}, {"org/jooq/impl/InsertQueryImpl", "toSQLInsert"}, {"org/jooq/impl/SelectQueryImpl", "toSQLReference0", "toSQLReferenceLimitDefault"}, {"org/jooq/impl/CursorImpl$CursorIterator", "fetch.*"}, {"org/jooq/impl/CursorImpl$CursorIterator", "hasNext"}, {"org/jooq/impl/CursorImpl$CursorIterator$CursorRecordInitialiser", "setValue"}, {"org/jooq/impl/CursorImpl$CursorResultSet", ".*"}, {"org/jooq/impl/CursorImpl", "close"}, {"org/jooq/impl/RecordDelegate", "operate"}, {"org/jooq/impl/DSL", "using"}, {"org/jooq/DSLContext", "fetch.*", "execute.*"}, {"org/jooq/tools/jdbc/JDBCUtils", "dialect", "safeClose"}, {"org/jooq/impl/Utils", "safeClose", "consumeWarnings", "fetch.*"}, {"org/jooq/impl/MetaDataFieldProvider", "init"}};

    public MethodDatabase.SuspendableType isSuspendable(MethodDatabase db, String sourceName, String sourceDebugInfo, boolean isInterface, String className, String superClassName, String[] interfaces, String methodName, String methodDesc, String methodSignature, String[] methodExceptions) {
        int i;
        for (String[] susExtendables : this.methodsArray) {
            if (!className.equals(susExtendables[0])) continue;
            for (i = 1; i < susExtendables.length; ++i) {
                if (!methodName.matches(susExtendables[i])) continue;
                if (db.isVerbose()) {
                    db.getLog().log(LogLevel.INFO, JooqClassifier.class.getName() + ": " + className + "." + methodName + " supersOrEqual " + susExtendables[0] + "." + susExtendables[i], new Object[0]);
                }
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        if (!className.startsWith(PKG_PREFIX)) {
            return null;
        }
        for (String[] susExtendables : this.methodsArray) {
            if (!SimpleSuspendableClassifier.extendsOrImplements((String)susExtendables[0], (MethodDatabase)db, (String)className, (String)superClassName, (String[])interfaces)) continue;
            for (i = 1; i < susExtendables.length; ++i) {
                if (!methodName.matches(susExtendables[i])) continue;
                if (db.isVerbose()) {
                    db.getLog().log(LogLevel.INFO, JooqClassifier.class.getName() + ": " + className + "." + methodName + " extends " + susExtendables[0] + "." + susExtendables[i], new Object[0]);
                }
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        return null;
    }
}

