/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.tomcat;

import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.QuasarInstrumentor;
import java.util.Arrays;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.loader.WebappClassLoader;

public class QuasarWebAppClassLoader
extends WebappClassLoader {
    private QuasarInstrumentor instrumentor;

    protected synchronized boolean filter(String name) {
        return name.startsWith("co.paralleluniverse.common.") || name.startsWith("co.paralleluniverse.fibers.instrument.") || name.startsWith("jsr166e") || name.startsWith("co.paralleluniverse.asm.");
    }

    public QuasarWebAppClassLoader() {
    }

    public QuasarWebAppClassLoader(ClassLoader parent) {
        super(parent);
    }

    private QuasarInstrumentor newInstrumentor() {
        QuasarInstrumentor inst = new QuasarInstrumentor((ClassLoader)((Object)this));
        inst.setLog(new Log(){

            @Override
            public void log(LogLevel level, String msg, Object ... args) {
                System.out.println("[quasar] " + (Object)((Object)level) + ": " + String.format(msg, args));
            }

            @Override
            public void error(String msg, Throwable exc) {
                System.out.println("[quasar] ERROR: " + msg);
                exc.printStackTrace(System.out);
            }
        });
        inst.setVerbose(false);
        inst.setDebug(false);
        return inst;
    }

    private synchronized void initInstrumentor() {
        if (this.instrumentor == null) {
            this.instrumentor = this.newInstrumentor();
        }
    }

    protected ResourceEntry findResourceInternal(String name, String path, boolean manifestRequired) {
        this.initInstrumentor();
        ResourceEntry entry = super.findResourceInternal(name, path, manifestRequired);
        if (entry != null && path.endsWith(".class") && entry.binaryContent != null) {
            String className = name.substring(0, name.length() - ".class".length());
            try {
                byte[] res = this.instrumentor.instrumentClass(className, entry.binaryContent);
                if (res != null) {
                    entry.binaryContent = res;
                }
            }
            catch (Exception ex) {
                if (MethodDatabase.isProblematicClass(className)) {
                    this.instrumentor.log(LogLevel.INFO, "Skipping problematic class instrumentation %s - %s %s", className, ex, Arrays.toString(ex.getStackTrace()));
                }
                this.instrumentor.error("Unable to instrument " + className, ex);
            }
        }
        return entry;
    }
}

