/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import co.paralleluniverse.io.serialization.kryo.CollectionsSetFromMapSerializer;
import co.paralleluniverse.io.serialization.kryo.ExternalizableKryoSerializer;
import co.paralleluniverse.io.serialization.kryo.KryoObjectInputStream;
import co.paralleluniverse.io.serialization.kryo.KryoObjectOutputStream;
import co.paralleluniverse.io.serialization.kryo.ReferenceSerializer;
import co.paralleluniverse.io.serialization.kryo.ReplaceableObjectKryo;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objenesis.strategy.SerializingInstantiatorStrategy;

public final class KryoUtil {
    public static Kryo newKryo() {
        ReplaceableObjectKryo kryo = new ReplaceableObjectKryo();
        kryo.setRegistrationRequired(false);
        kryo.setInstantiatorStrategy(new SerializingInstantiatorStrategy());
        KryoUtil.registerCommonClasses(kryo);
        return kryo;
    }

    public static void registerCommonClasses(Kryo kryo) {
        kryo.register(boolean[].class);
        kryo.register(byte[].class);
        kryo.register(short[].class);
        kryo.register(char[].class);
        kryo.register(int[].class);
        kryo.register(float[].class);
        kryo.register(long[].class);
        kryo.register(double[].class);
        kryo.register(String[].class);
        kryo.register(int[][].class);
        kryo.register(ArrayList.class);
        kryo.register(LinkedList.class);
        kryo.register(HashMap.class);
        kryo.register(LinkedHashMap.class);
        kryo.register(TreeMap.class);
        kryo.register(EnumMap.class);
        kryo.register(HashSet.class);
        kryo.register(TreeSet.class);
        kryo.register(EnumSet.class);
        kryo.register(Arrays.asList("").getClass(), new ArraysAsListSerializer());
        kryo.register(Collections.newSetFromMap(new HashMap()).getClass(), new CollectionsSetFromMapSerializer());
        kryo.register(GregorianCalendar.class, new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, new JdkProxySerializer());
        UnmodifiableCollectionsSerializer.registerSerializers(kryo);
        SynchronizedCollectionsSerializer.registerSerializers(kryo);
        kryo.addDefaultSerializer(Externalizable.class, new ExternalizableKryoSerializer());
        kryo.addDefaultSerializer(Reference.class, new ReferenceSerializer());
    }

    public static ObjectOutput asObjectOutput(Output output, Kryo kryo) {
        return new KryoObjectOutputStream(output, kryo);
    }

    public static ObjectInput asObjectInput(Input input, Kryo kryo) {
        return new KryoObjectInputStream(input, kryo);
    }

    private KryoUtil() {
    }
}

