/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class ReplacableObjectSerializer
extends FieldSerializer<Object> {
    public ReplacableObjectSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    public void write(Kryo kryo, Output output, Object object) {
        super.write(kryo, output, ReplacableObjectSerializer.getReplacement(object, "writeReplace"));
    }

    @Override
    public Object read(Kryo kryo, Input input, Class<Object> type) {
        return ReplacableObjectSerializer.getReplacement(super.read(kryo, input, type), "readResolve");
    }

    private static Object getReplacement(Object obj, String replaceMethodName) {
        try {
            Class<?> clazz = obj.getClass();
            if (!Serializable.class.isAssignableFrom(clazz)) {
                return obj;
            }
            Method m = null;
            try {
                m = clazz.getDeclaredMethod(replaceMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                for (Class<?> ancestor = clazz.getSuperclass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
                    if (!Serializable.class.isAssignableFrom(ancestor)) {
                        return obj;
                    }
                    try {
                        m = ancestor.getDeclaredMethod(replaceMethodName, new Class[0]);
                        if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers())) {
                            return obj;
                        }
                        break;
                    }
                    catch (NoSuchMethodException ex1) {
                        continue;
                    }
                }
            }
            if (m == null) {
                return obj;
            }
            m.setAccessible(true);
            Object replacement = m.invoke(obj, new Object[0]);
            return replacement;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException) {
                ((InvocationTargetException)ex).getTargetException().printStackTrace();
            }
            return obj;
        }
    }
}

