/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;

public class ImmutableListSerializer
extends Serializer<ImmutableList<Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableListSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableList<Object> object) {
        output.writeInt(object.size(), true);
        for (Object e : object) {
            kryo.writeClassAndObject(output, e);
        }
    }

    @Override
    public ImmutableList<Object> read(Kryo kryo, Input input, Class<ImmutableList<Object>> type) {
        int size = input.readInt(true);
        Object[] list = new Object[size];
        for (int i = 0; i < size; ++i) {
            list[i] = kryo.readClassAndObject(input);
        }
        return ImmutableList.copyOf(list);
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableListSerializer serializer = new ImmutableListSerializer();
        kryo.register(ImmutableList.class, serializer);
        kryo.register(ImmutableList.of().getClass(), serializer);
        kryo.register(ImmutableList.of(Integer.valueOf(1)).getClass(), serializer);
        kryo.register(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).subList(1, 2).getClass(), serializer);
        kryo.register(ImmutableList.of().reverse().getClass(), serializer);
        kryo.register(Lists.charactersOf("KryoRocks").getClass(), serializer);
        HashBasedTable<Integer, Integer, Integer> baseTable = HashBasedTable.create();
        baseTable.put(1, 2, 3);
        baseTable.put(4, 5, 6);
        ImmutableTable table = ImmutableTable.copyOf(baseTable);
        kryo.register(table.values().getClass(), serializer);
    }
}

