package co.saltpay.epos.request.handlerlib.events

import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.asSharedFlow

internal object BroadcastEventPubSub : BroadcastEventsSubscriber, BroadcastEventsPublisher {

    private val mutableFlow = MutableSharedFlow<SenderBackgroundRequest>()

    override suspend fun publish(requestModel: SenderBackgroundRequest) {
        mutableFlow.emit(requestModel)
    }

    override val requestsFlow: SharedFlow<SenderBackgroundRequest>
        get() = mutableFlow.asSharedFlow()
}