package co.saltpay.epos.request.handlerlib.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import co.saltpay.epos.models.mappers.*
import co.saltpay.epos.models.request.BackgroundRequest
import co.saltpay.epos.request.handlerlib.Logger
import co.saltpay.epos.request.handlerlib.asLog
import co.saltpay.epos.request.handlerlib.di.CompositionRootAccessor
import co.saltpay.epos.request.handlerlib.di.compositionRoot
import co.saltpay.epos.request.handlerlib.events.BroadcastEventsPublisher
import co.saltpay.epos.request.handlerlib.events.SenderBackgroundRequest
import kotlinx.coroutines.runBlocking

internal class RequestBroadcastReceiver : BroadcastReceiver(), CompositionRootAccessor {

    private val publisher: BroadcastEventsPublisher get() = compositionRoot.eventsPublisher
    private val logger: Logger get() = compositionRoot.logger

    override fun onReceive(context: Context?, intent: Intent) = runBlocking {
        if (intent.action != INTENT_BACKGROUND_REQUEST_ACTION) {
            return@runBlocking
        }

        val backgroundRequest = kotlin.runCatching {
            SenderBackgroundRequest.Valid(
                backgroundRequest = intent.toRequestModel() as BackgroundRequest,
                requestingPackage = intent.requestingPackage,
                requestingLibVersion = intent.requestingLibVersion,
                requestId = intent.requestId
            )
        }.getOrElse {
            val request = SenderBackgroundRequest.Invalid(
                requestingPackage = intent.requestingPackage,
                requestingLibVersion = intent.requestingLibVersion,
                requestId = intent.requestId
            )

            logger.e("RequestBroadcastReceiver", "Couldn't parse received intent. Reason: ${it.asLog()}, invalid request: $request")

            publisher.publish(request)
            return@runBlocking
        }

        logger.i("RequestBroadcastReceiver", "Request received = $backgroundRequest")

        publisher.publish(backgroundRequest)
    }
}