/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionType;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import co.streamx.fluent.extree.expression.UnaryExpression;
import lombok.NonNull;

public final class BinaryExpression
extends UnaryExpression {
    private final Expression operator;
    private final Expression second;

    BinaryExpression(int expressionType, Class<?> resultType, Expression operator, Expression first, @NonNull Expression second) {
        super(expressionType, resultType, first);
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        if (expressionType == 6 && operator == null) {
            throw new IllegalArgumentException(new NullPointerException("operator"));
        }
        this.operator = operator;
        this.second = second;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.getOperator() != null) {
            b.append(this.getOperator().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
            b.append(' ');
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(':');
        } else {
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(' ');
        b.append(this.getSecond().toString());
        b.append(')');
        return b.toString();
    }

    public Expression getOperator() {
        return this.operator;
    }

    public Expression getSecond() {
        return this.second;
    }
}

