/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import co.streamx.fluent.extree.expression.InvocableExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import java.util.List;
import lombok.NonNull;

public final class DelegateExpression
extends InvocableExpression {
    private final Expression delegate;

    DelegateExpression(Class<?> resultType, @NonNull Expression delegate, List<ParameterExpression> params) {
        super(18, resultType, params);
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (!InvocableExpression.class.isAssignableFrom(delegate.getResultType())) {
            throw new IllegalArgumentException("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append(this.getDelegate());
        b.append('}');
        return b.toString();
    }

    public Expression getDelegate() {
        return this.delegate;
    }
}

