/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.ConstantExpression;
import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionClassVisitor;
import co.streamx.fluent.extree.expression.InvocableExpression;
import co.streamx.fluent.extree.expression.InvocationExpression;
import co.streamx.fluent.extree.expression.LambdaExpression;
import co.streamx.fluent.extree.expression.MemberExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.SimpleExpressionVisitor;
import co.streamx.fluent.extree.expression.TypeConverter;
import co.streamx.fluent.extree.expression.UnaryExpression;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

class ExpressionClassCracker {
    private static final String DUMP_FOLDER_SYSTEM_PROPERTY = "jdk.internal.lambda.dumpProxyClasses";
    private static final URLClassLoader lambdaClassLoader;
    private static final String lambdaClassLoaderCreationError;
    private static final ExpressionClassCracker instance;
    private static final Map<SerializedDescriptor, LambdaExpression<?>> cache;

    public static ExpressionClassCracker get() {
        return instance;
    }

    private ExpressionClassCracker() {
    }

    LambdaExpression<?> lambda(Object lambda, boolean synthetic) {
        return this.lambda(lambda, null, synthetic);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LambdaExpression<?> lambda(Object lambda, Method lambdaMethod, boolean synthetic) {
        Class<?> lambdaClass = lambda.getClass();
        if (!ExpressionClassCracker.isFunctional(lambdaClass)) {
            throw new IllegalArgumentException("The requested object is not a Java lambda");
        }
        if (!(lambda instanceof Serializable)) return this.lambdaFromFileSystem(lambda, lambdaMethod, null);
        try (SerializedLambdaObjectExtractor extractor = new SerializedLambdaObjectExtractor();){
            SerializedLambda extracted = extractor.extract(lambda);
            ClassLoader lambdaClassLoader = lambdaClass.getClassLoader();
            LambdaExpression<?> lambdaExpression = this.lambda(extracted, lambdaClassLoader, synthetic);
            return lambdaExpression;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    LambdaExpression<?> lambdaFromFileSystem(Object lambda, Method lambdaMethod, ClassLoader classLoader) {
        ExpressionClassVisitor lambdaVisitor = this.parseFromFileSystem(lambda, lambdaMethod, classLoader);
        return this.createLambda(lambdaVisitor, null);
    }

    LambdaExpression<?> lambdaFromClassLoader(ClassLoader classLoader, String className, Expression instance, String method, String methodDescriptor) {
        LambdaExpression<?> cached;
        LambdaExpression<?> cached2;
        boolean isCacheable;
        SerializedDescriptor desc = new SerializedDescriptor(className, method, methodDescriptor, -1, methodDescriptor);
        boolean bl = isCacheable = instance == null || instance.getResultType().isSynthetic();
        if (isCacheable && (cached2 = cache.get(desc)) != null) {
            return cached2;
        }
        ExpressionClassVisitor lambdaVisitor = this.parseClass(classLoader, className, instance, method, methodDescriptor);
        LambdaExpression<?> parsed = this.createLambda(lambdaVisitor, desc);
        if (isCacheable && (cached = cache.putIfAbsent(desc, parsed)) != null) {
            parsed = cached;
        }
        return parsed;
    }

    private LambdaExpression<?> createLambda(ExpressionClassVisitor lambdaVisitor, SerializedDescriptor key) {
        List<ParameterExpression> lambdaParams;
        Class<?> lambdaType;
        Expression lambdaExpression;
        block8: {
            InvocationExpression invocation;
            InvocableExpression target;
            lambdaExpression = lambdaVisitor.getResult();
            lambdaType = lambdaVisitor.getType();
            lambdaParams = Arrays.asList(lambdaVisitor.getParams());
            Expression stripped = lambdaType == Void.TYPE ? null : this.stripConvertExpressions(lambdaExpression);
            List<Expression> block = lambdaVisitor.getStatements();
            if (block != null && !block.isEmpty()) {
                block = new ArrayList<Expression>(block);
                if (lambdaExpression != null) {
                    block.add(lambdaExpression);
                }
                lambdaExpression = Expression.block(lambdaType, block);
            } else if (stripped instanceof InvocationExpression && (target = (invocation = (InvocationExpression)stripped).getTarget()) instanceof LambdaExpression && lambdaType.isAssignableFrom(target.getResultType())) {
                List<ParameterExpression> params = lambdaParams;
                List<Expression> args = invocation.getArguments();
                int psize = params.size();
                if (psize == args.size()) {
                    for (int i = 0; i < psize; ++i) {
                        Expression arg = args.get(i);
                        if (arg instanceof ParameterExpression) {
                            ParameterExpression parg = (ParameterExpression)arg;
                            ParameterExpression param = params.get(i);
                            if (parg.getIndex() == param.getIndex() && param.getResultType().isAssignableFrom(parg.getResultType())) {
                                continue;
                            }
                        }
                        break block8;
                    }
                    return (LambdaExpression)target;
                }
            }
        }
        Expression actualExpression = TypeConverter.convert(lambdaExpression, lambdaType);
        return Expression.lambda(lambdaType, actualExpression, lambdaParams, lambdaVisitor.getLocals(), key);
    }

    LambdaExpression<?> lambda(SerializedLambda extracted, ClassLoader lambdaClassLoader) {
        return this.lambda(extracted, lambdaClassLoader, true);
    }

    LambdaExpression<?> lambda(SerializedLambda extracted, ClassLoader lambdaClassLoader, boolean synthetic) {
        int boundArgs;
        int i;
        ParameterExpression[] params;
        LambdaExpression<?> cached;
        boolean isCacheable;
        Expression instance;
        boolean hasThis;
        int capturedLength = extracted.getCapturedArgCount();
        SerializedDescriptor desc = new SerializedDescriptor(extracted);
        boolean bl = hasThis = extracted.getImplMethodKind() == 9 || extracted.getImplMethodKind() == 7 || extracted.getImplMethodKind() == 5;
        if (hasThis) {
            if (capturedLength == 0) {
                try {
                    instance = Expression.parameter(lambdaClassLoader.loadClass(extracted.getImplClass().replace('/', '.')), 0);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Object arg0 = extracted.getCapturedArg(0);
                if (desc != null) {
                    desc = desc.withImplClass(arg0.getClass().getName());
                }
                instance = Expression.constant(arg0);
            }
        } else {
            instance = null;
        }
        boolean noNeedHandleCapturedArgs = capturedLength == 0 || hasThis && capturedLength <= 1;
        boolean bl2 = isCacheable = noNeedHandleCapturedArgs && (!hasThis || instance.getResultType().isSynthetic());
        if (isCacheable && (cached = cache.get(desc)) != null) {
            return cached;
        }
        ExpressionClassVisitor actualVisitor = this.parseClass(lambdaClassLoader, extracted.getImplClass(), instance, extracted.getImplMethodName(), extracted.getImplMethodSignature(), synthetic);
        Class<?> type = actualVisitor.getType();
        Expression reducedExpression = type == Void.TYPE ? null : TypeConverter.convert(actualVisitor.getResult(), type);
        List<Expression> block = actualVisitor.getStatements();
        if (block != null && !block.isEmpty()) {
            block = new ArrayList<Expression>(block);
            if (reducedExpression != null) {
                block.add(reducedExpression);
            }
            reducedExpression = Expression.block(type, block);
        }
        if (capturedLength == 0) {
            Type[] argTypes = Type.getArgumentTypes((String)extracted.getInstantiatedMethodType());
            params = new ParameterExpression[argTypes.length];
            for (int i2 = 0; i2 < argTypes.length; ++i2) {
                params[i2] = Expression.parameter(actualVisitor.getClass(argTypes[i2]), i2);
            }
        } else {
            params = actualVisitor.getParams();
        }
        LambdaExpression extractedLambda = Expression.lambda(type, reducedExpression, Collections.unmodifiableList(Arrays.asList(params)), actualVisitor.getLocals(), desc);
        if (noNeedHandleCapturedArgs) {
            LambdaExpression<?> cached2;
            if (isCacheable && (cached2 = cache.putIfAbsent(desc, extractedLambda)) != null) {
                extractedLambda = cached2;
            }
            return extractedLambda;
        }
        ArrayList<Expression> args = new ArrayList<Expression>(params.length);
        int n = i = hasThis ? 1 : 0;
        while (i < capturedLength) {
            LambdaExpression<?> arg = extracted.getCapturedArg(i);
            if (arg instanceof SerializedLambda) {
                SerializedLambda argLambda = (SerializedLambda)((Object)arg);
                LambdaExpression<?> argExtractedLambda = this.lambda(argLambda, lambdaClassLoader);
                extractedLambda = (LambdaExpression)extractedLambda.accept(new ParameterReplacer(args.size(), null));
                arg = argExtractedLambda;
            }
            args.add(Expression.constant(arg));
            ++i;
        }
        ArrayList<ParameterExpression> finalParams = new ArrayList<ParameterExpression>(params.length - capturedLength);
        for (int y = boundArgs = args.size(); y < params.length; ++y) {
            ParameterExpression param = params[y];
            ParameterExpression arg = Expression.parameter(param.getResultType(), y - boundArgs);
            args.add(arg);
            finalParams.add(arg);
        }
        InvocationExpression newTarget = Expression.invoke(extractedLambda, args);
        return Expression.lambda(type, newTarget, Collections.unmodifiableList(finalParams), Collections.emptyList(), desc);
    }

    <T extends Expression> T parseSyntheticArguments(T expression, List<Expression> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Object value;
            Expression e = arguments.get(i);
            if (e.getExpressionType() != 7 || (value = ((ConstantExpression)e).getValue()) == null || !ExpressionClassCracker.isFunctional(value.getClass())) continue;
            ParameterReplacer replacer = new ParameterReplacer(i, value);
            expression = expression.accept(replacer);
            if (replacer.getParsedLambda() == null) continue;
            arguments.set(i, Expression.constant(replacer.getParsedLambda()));
        }
        return (T)expression;
    }

    private static boolean isFunctional(Class<?> clazz) {
        if (clazz.isSynthetic()) {
            return true;
        }
        for (Class<?> i : clazz.getInterfaces()) {
            if (!i.isAnnotationPresent(FunctionalInterface.class)) continue;
            return true;
        }
        return false;
    }

    ExpressionClassVisitor parseFromFileSystem(Object lambda, Method lambdaMethod, ClassLoader classLoader) {
        Class<?> lambdaClass;
        if (classLoader == null) {
            if (lambdaClassLoader == null) {
                throw new RuntimeException(lambdaClassLoaderCreationError);
            }
            classLoader = lambdaClassLoader;
        }
        if (lambdaMethod == null) {
            lambdaClass = lambda.getClass();
            lambdaMethod = this.findFunctionalMethod(lambdaClass);
        } else {
            lambdaClass = lambdaMethod.getDeclaringClass();
        }
        String lambdaClassName = this.lambdaClassName(lambdaClass);
        return this.parseClass(classLoader, lambdaClassName, lambda instanceof Expression ? (Expression)lambda : Expression.constant(lambda), lambdaMethod);
    }

    private String lambdaClassName(Class<?> lambdaClass) {
        String lambdaClassName = lambdaClass.getName();
        int lastIndexOfSlash = lambdaClassName.lastIndexOf(47);
        String className = lastIndexOfSlash > 0 ? lambdaClassName.substring(0, lastIndexOfSlash) : lambdaClassName;
        return className;
    }

    private String classFilePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    private Method findFunctionalMethod(Class<?> functionalClass) {
        for (Method m : functionalClass.getMethods()) {
            if (m.isDefault()) continue;
            return m;
        }
        throw new IllegalArgumentException("Not a lambda expression. No non-default method.");
    }

    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String className, Expression instance, Method method) {
        return this.parseClass(classLoader, className, instance, method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String className, Expression instance, String method, String methodDescriptor) {
        return this.parseClass(classLoader, className, instance, method, methodDescriptor, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String className, Expression instance, String method, String methodDescriptor, boolean synthetic) {
        String classFilePath = this.classFilePath(className);
        ExpressionClassVisitor visitor = new ExpressionClassVisitor(classLoader, instance, method, methodDescriptor, synthetic);
        try (InputStream classStream = this.getResourceAsStream(classLoader, classFilePath);){
            ClassReader reader = new ClassReader(classStream);
            reader.accept((ClassVisitor)visitor, 6);
            ExpressionClassVisitor expressionClassVisitor = visitor;
            return expressionClassVisitor;
        }
        catch (IOException e) {
            throw new RuntimeException("error parsing class file " + classFilePath, e);
        }
    }

    private InputStream getResourceAsStream(ClassLoader classLoader, String path) throws FileNotFoundException {
        InputStream stream = classLoader.getResourceAsStream(path);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return stream;
    }

    private Expression stripConvertExpressions(Expression expression) {
        while (expression.getExpressionType() == 8) {
            expression = ((UnaryExpression)expression).getFirst();
        }
        return expression;
    }

    static {
        instance = new ExpressionClassCracker();
        String folderPath = System.getProperty(DUMP_FOLDER_SYSTEM_PROPERTY);
        if (folderPath == null) {
            lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set.";
            lambdaClassLoader = null;
        } else {
            File folder = new File(folderPath);
            if (!folder.isDirectory()) {
                lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set (" + folderPath + " does not exist).";
                lambdaClassLoader = null;
            } else {
                URL folderURL;
                try {
                    folderURL = folder.toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
                lambdaClassLoaderCreationError = null;
                lambdaClassLoader = new URLClassLoader(new URL[]{folderURL});
            }
        }
        cache = new ConcurrentHashMap();
    }

    private static class SerializedDescriptor {
        private final String implClass;
        private final String implMethodName;
        private final String implMethodSignature;
        private final int implMethodKind;
        private final String instantiatedMethodType;

        public SerializedDescriptor(SerializedLambda lambda) {
            this.implClass = lambda.getImplClass();
            this.implMethodName = lambda.getImplMethodName();
            this.implMethodSignature = lambda.getImplMethodSignature();
            this.implMethodKind = lambda.getImplMethodKind();
            this.instantiatedMethodType = lambda.getInstantiatedMethodType();
        }

        public SerializedDescriptor withImplClass(String implClass) {
            return new SerializedDescriptor(implClass, implClass, implClass, this.implMethodKind, implClass);
        }

        public String getImplClass() {
            return this.implClass;
        }

        public String getImplMethodName() {
            return this.implMethodName;
        }

        public String getImplMethodSignature() {
            return this.implMethodSignature;
        }

        public int getImplMethodKind() {
            return this.implMethodKind;
        }

        public String getInstantiatedMethodType() {
            return this.instantiatedMethodType;
        }

        public String toString() {
            return "ExpressionClassCracker.SerializedDescriptor(implClass=" + this.getImplClass() + ", implMethodName=" + this.getImplMethodName() + ", implMethodSignature=" + this.getImplMethodSignature() + ", implMethodKind=" + this.getImplMethodKind() + ", instantiatedMethodType=" + this.getInstantiatedMethodType() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedDescriptor)) {
                return false;
            }
            SerializedDescriptor other = (SerializedDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getImplMethodKind() != other.getImplMethodKind()) {
                return false;
            }
            String this$implClass = this.getImplClass();
            String other$implClass = other.getImplClass();
            if (this$implClass == null ? other$implClass != null : !this$implClass.equals(other$implClass)) {
                return false;
            }
            String this$implMethodName = this.getImplMethodName();
            String other$implMethodName = other.getImplMethodName();
            if (this$implMethodName == null ? other$implMethodName != null : !this$implMethodName.equals(other$implMethodName)) {
                return false;
            }
            String this$implMethodSignature = this.getImplMethodSignature();
            String other$implMethodSignature = other.getImplMethodSignature();
            if (this$implMethodSignature == null ? other$implMethodSignature != null : !this$implMethodSignature.equals(other$implMethodSignature)) {
                return false;
            }
            String this$instantiatedMethodType = this.getInstantiatedMethodType();
            String other$instantiatedMethodType = other.getInstantiatedMethodType();
            return !(this$instantiatedMethodType == null ? other$instantiatedMethodType != null : !this$instantiatedMethodType.equals(other$instantiatedMethodType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SerializedDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getImplMethodKind();
            String $implClass = this.getImplClass();
            result = result * 59 + ($implClass == null ? 43 : $implClass.hashCode());
            String $implMethodName = this.getImplMethodName();
            result = result * 59 + ($implMethodName == null ? 43 : $implMethodName.hashCode());
            String $implMethodSignature = this.getImplMethodSignature();
            result = result * 59 + ($implMethodSignature == null ? 43 : $implMethodSignature.hashCode());
            String $instantiatedMethodType = this.getInstantiatedMethodType();
            result = result * 59 + ($instantiatedMethodType == null ? 43 : $instantiatedMethodType.hashCode());
            return result;
        }

        public SerializedDescriptor(String implClass, String implMethodName, String implMethodSignature, int implMethodKind, String instantiatedMethodType) {
            this.implClass = implClass;
            this.implMethodName = implMethodName;
            this.implMethodSignature = implMethodSignature;
            this.implMethodKind = implMethodKind;
            this.instantiatedMethodType = instantiatedMethodType;
        }
    }

    private static class SerializedLambdaObjectExtractor
    extends ObjectOutputStream {
        private SerializedLambda serializedLambda;

        public SerializedLambdaObjectExtractor() throws IOException {
            super(new ByteArrayOutputStream(8));
            this.enableReplaceObject(true);
        }

        public SerializedLambda extract(Object lambda) throws IOException {
            this.writeObject(lambda);
            return this.serializedLambda;
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            this.serializedLambda = (SerializedLambda)obj;
            return null;
        }
    }

    private static final class ParameterReplacer
    extends SimpleExpressionVisitor {
        private List<Integer> paramIndices;
        private final Object lambda;
        private LambdaExpression<?> parsedLambda;
        private List<Integer> prevParamIndices;

        public ParameterReplacer(int paramIndex, Object lambda) {
            this.paramIndices = Arrays.asList(paramIndex);
            this.lambda = lambda;
        }

        public LambdaExpression<?> getParsedLambda() {
            return this.parsedLambda;
        }

        @Override
        public Expression visit(InvocationExpression e) {
            if (this.paramIndices.isEmpty()) {
                return e;
            }
            this.prevParamIndices = this.paramIndices;
            try {
                Expression expression = super.visit(e);
                return expression;
            }
            finally {
                this.paramIndices = this.prevParamIndices;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Expression> visitArguments(List<Expression> original) {
            try {
                List<Expression> list = super.visitArguments(original);
                return list;
            }
            finally {
                List<Integer> paramIndices = this.paramIndices;
                ArrayList<Integer> newParamIndices = new ArrayList<Integer>();
                for (int i = 0; i < original.size(); ++i) {
                    ParameterExpression p;
                    Expression e = original.get(i);
                    if (e.getExpressionType() != 34 || !paramIndices.contains((p = (ParameterExpression)e).getIndex())) continue;
                    newParamIndices.add(i);
                }
                this.paramIndices = newParamIndices;
            }
        }

        @Override
        public Expression visit(MemberExpression e) {
            int index;
            Expression instance = e.getInstance();
            if (instance != null && instance.getExpressionType() == 34 && this.prevParamIndices.contains(index = ((ParameterExpression)instance).getIndex())) {
                if (this.lambda != null && this.parsedLambda == null) {
                    Method method = (Method)e.getMember();
                    try {
                        method = this.lambda.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                    this.parsedLambda = ExpressionClassCracker.get().lambda(this.lambda, method, true);
                }
                return Expression.delegate(e.getResultType(), Expression.parameter(LambdaExpression.class, index), this.visitParameters(e.getParameters()));
            }
            return super.visit(e);
        }
    }
}

