/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.ConstantExpression;
import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionMethodVisitor;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.UnaryExpression;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ExpressionClassVisitor
extends ClassVisitor {
    private final ClassLoader _loader;
    private final Expression _me;
    private final String _method;
    private final String _methodDesc;
    private final boolean _synthetic;
    private Expression _result;
    private Class<?> _type;
    private Class<?>[] _argTypes;
    private Type _objectType;
    private List<Expression> statements;
    private List<Expression> locals;

    Expression getResult() {
        return this._result;
    }

    void setResult(Expression result) {
        this._result = result;
    }

    void setStatements(List<Expression> statements) {
        this.statements = statements;
    }

    List<Expression> getStatements() {
        return this.statements;
    }

    void setLocals(List<Expression> locals) {
        this.locals = locals;
    }

    List<Expression> getLocals() {
        return this.locals;
    }

    Class<?> getType() {
        return this._type;
    }

    ParameterExpression[] getParams() {
        ParameterExpression[] params = new ParameterExpression[this._argTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = Expression.parameter(this._argTypes[i], i);
        }
        return params;
    }

    public ExpressionClassVisitor(ClassLoader loader, Expression instance, String method, String methodDescriptor, boolean synthetic) {
        super(589824);
        this._loader = loader;
        this._me = instance;
        this._method = method;
        this._methodDesc = methodDescriptor;
        this._synthetic = synthetic;
    }

    ClassLoader getLoader() {
        return this._loader;
    }

    Class<?> getClass(Type t) {
        try {
            switch (t.getSort()) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Character.TYPE;
                }
                case 3: {
                    return Byte.TYPE;
                }
                case 4: {
                    return Short.TYPE;
                }
                case 5: {
                    return Integer.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
                case 0: {
                    return Void.TYPE;
                }
            }
            String cn = t.getInternalName();
            cn = cn != null ? cn.replace('/', '.') : t.getClassName();
            return Class.forName(cn, false, this._loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this._method.equals(name) || !this._methodDesc.equals(desc)) {
            return null;
        }
        Type ret = Type.getReturnType((String)desc);
        this._type = this.getClass(ret);
        Type[] args = Type.getArgumentTypes((String)desc);
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = this.getClass(args[i]);
        }
        if (this._synthetic && this._objectType != null && (access & 0x1000) == 0) {
            try {
                Expression instance;
                int parameterBase;
                boolean isStatic = (access & 8) != 0;
                boolean isCtor = !isStatic && "<init>".equals(name);
                Class<?> implClass = this.getClass(this._objectType);
                Expression[] arguments = new Expression[argTypes.length];
                if (isStatic || isCtor) {
                    parameterBase = 0;
                    instance = null;
                    if (isCtor) {
                        this._type = implClass;
                    }
                } else if (this._me != null) {
                    instance = this._me;
                    parameterBase = this._me instanceof ParameterExpression ? 1 : 0;
                } else {
                    parameterBase = 1;
                    instance = Expression.parameter(implClass, 0);
                }
                for (int i = 0; i < argTypes.length; ++i) {
                    Class argType = argTypes[i];
                    arguments[i] = Expression.parameter(argType, i + parameterBase);
                }
                this._result = isCtor ? Expression.newInstance(implClass, argTypes, arguments) : (isStatic ? Expression.invoke(implClass, name, argTypes, arguments) : Expression.invoke(instance, name, argTypes, arguments));
                this.locals = Collections.emptyList();
                if (parameterBase == 0) {
                    this._argTypes = argTypes;
                } else {
                    this._argTypes = new Class[argTypes.length + 1];
                    this._argTypes[0] = implClass;
                    System.arraycopy(argTypes, 0, this._argTypes, 1, argTypes.length);
                }
                return null;
            }
            catch (Throwable isStatic) {
                // empty catch block
            }
        }
        Expression me = this._me;
        if ((access & 8) == 0) {
            if (me != null && !ExpressionClassVisitor.isConstant(me)) {
                Class[] newArgTypes = new Class[argTypes.length + 1];
                newArgTypes[0] = me.getResultType();
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                argTypes = newArgTypes;
                me = null;
            }
        } else {
            me = null;
        }
        this._argTypes = argTypes;
        return new ExpressionMethodVisitor(this, me, argTypes);
    }

    private static boolean isConstant(Expression e) {
        while (e.getExpressionType() == 8) {
            e = ((UnaryExpression)e).getFirst();
        }
        return e instanceof ConstantExpression;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1000) == 0) {
            this._objectType = Type.getObjectType((String)name);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }
}

