/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.BinaryExpression;
import co.streamx.fluent.extree.expression.ConstantExpression;
import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionClassCracker;
import co.streamx.fluent.extree.expression.ExpressionClassVisitor;
import co.streamx.fluent.extree.expression.ExpressionStack;
import co.streamx.fluent.extree.expression.Interpreter;
import co.streamx.fluent.extree.expression.InvocationExpression;
import co.streamx.fluent.extree.expression.LambdaExpression;
import co.streamx.fluent.extree.expression.NewArrayInitExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.TypeConverter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

final class ExpressionMethodVisitor
extends MethodVisitor {
    private static final Class<?>[] NumericTypeLookup = new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] NumericTypeLookup2 = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE};
    private static final String LambdaMetafactoryClassInternalName = LambdaMetafactory.class.getName().replace('.', '/');
    private static final Map<Class<?>, Class<?>> _primitives;
    private static final Class<?>[] arrayTypesByCode;
    private ExpressionStack _exprStack;
    private List<Expression> _statements;
    private Expression[] _localVariables;
    private final HashMap<Label, List<ExpressionStack>> _branches = new HashMap();
    private final ExpressionClassVisitor _classVisitor;
    private final Class<?>[] _argTypes;
    private final Expression _me;

    ExpressionMethodVisitor(ExpressionClassVisitor classVisitor, Expression me, Class<?>[] argTypes) {
        super(589824);
        this._classVisitor = classVisitor;
        this._me = me;
        this._argTypes = argTypes;
    }

    private static Class<?> normalizePrimitive(Class<?> clz) {
        Class<?> primitive = _primitives.get(clz);
        return primitive != null ? primitive : clz;
    }

    private List<ExpressionStack> getBranchUsers(Label label) {
        List<ExpressionStack> bl = this._branches.get(label);
        if (bl == null) {
            bl = new ArrayList<ExpressionStack>();
            this._branches.put(label, bl);
        }
        return bl;
    }

    private void go(Label label) {
        this.getBranchUsers(label).add(this._exprStack);
        this._exprStack = null;
    }

    private void branch(Label label, Expression test) {
        List<ExpressionStack> bl = this.getBranchUsers(label);
        ExpressionStack.BranchExpression br = new ExpressionStack.BranchExpression(this._exprStack, test);
        this._exprStack.push(br);
        ExpressionStack left = br.getFalse();
        bl.add(left);
        this._exprStack = br.getTrue();
    }

    private void pushZeroConstantOrReduce() {
        Comparable<Byte> value;
        Expression e = this._exprStack.peek();
        if (e.getExpressionType() == 36) {
            BinaryExpression be = (BinaryExpression)this._exprStack.pop();
            this._exprStack.push(be.getFirst());
            this._exprStack.push(be.getSecond());
            return;
        }
        Class<?> type = this._exprStack.peek().getResultType();
        if (type == Byte.TYPE) {
            value = (byte)0;
        } else if (type == Double.TYPE) {
            value = 0.0;
        } else if (type == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (type == Integer.TYPE) {
            value = 0;
        } else if (type == Long.TYPE) {
            value = 0L;
        } else if (type == Short.TYPE) {
            value = (short)0;
        } else if (type == Boolean.TYPE) {
            value = Boolean.FALSE;
        } else {
            throw new IllegalStateException(type.toString());
        }
        this._exprStack.push(Expression.constant(value, type));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitCode() {
        this._exprStack = new ExpressionStack();
    }

    public void visitEnd() {
        this.visitLabel(null);
        if (this._exprStack.isEmpty()) {
            assert (this._classVisitor.getType() == Void.TYPE);
        } else if (this._classVisitor.getType() == Void.TYPE) {
            if (this._statements == null) {
                this._statements = new ArrayList<Expression>(this._exprStack);
            } else {
                this._statements.addAll(this._exprStack);
                this._exprStack.sort(this._statements);
            }
        } else {
            assert (this._exprStack.size() == 1);
            this._classVisitor.setResult(this._exprStack.pop());
        }
        this._classVisitor.setStatements(this._statements);
        this._classVisitor.setLocals(this._localVariables != null ? Collections.unmodifiableList(Arrays.asList(this._localVariables)) : Collections.emptyList());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Expression e;
        boolean isSyntheticConstant = false;
        switch (opcode) {
            case 180: {
                Expression instance = this._exprStack.pop();
                try {
                    e = Expression.get(instance, name);
                }
                catch (NoSuchFieldException nsfe) {
                    throw new RuntimeException(nsfe);
                }
                if (instance.getExpressionType() != 7 || !instance.getResultType().isSynthetic()) break;
                isSyntheticConstant = true;
                break;
            }
            case 178: {
                try {
                    Class<?> containingClass = this._classVisitor.getClass(Type.getObjectType((String)owner));
                    e = Expression.get(containingClass, name);
                    if (!containingClass.isSynthetic()) break;
                    isSyntheticConstant = true;
                    break;
                }
                catch (NoSuchFieldException nsfe) {
                    throw new RuntimeException(nsfe);
                }
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
        if (isSyntheticConstant) {
            Object value = ((Function)e.accept(Interpreter.Instance)).apply(null);
            e = Expression.constant(value, e.getResultType());
        }
        this._exprStack.push(e);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        throw ExpressionMethodVisitor.notLambda(type);
    }

    public void visitIincInsn(int arg0, int arg1) {
        throw ExpressionMethodVisitor.notLambda(132);
    }

    public void visitInsn(int opcode) {
        Expression e;
        switch (opcode) {
            case 190: {
                e = Expression.arrayLength(this._exprStack.pop());
                break;
            }
            case 1: {
                e = Expression.constant(null, Object.class);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.arrayIndex(second, first);
                break;
            }
            case 14: {
                e = Expression.constant(0.0, Double.TYPE);
                break;
            }
            case 15: {
                e = Expression.constant(1.0, Double.TYPE);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.subtract(second, first);
                break;
            }
            case 11: {
                e = Expression.constant(Float.valueOf(0.0f), Float.TYPE);
                break;
            }
            case 12: {
                e = Expression.constant(Float.valueOf(1.0f), Float.TYPE);
                break;
            }
            case 13: {
                e = Expression.constant(Float.valueOf(2.0f), Float.TYPE);
                break;
            }
            case 2: {
                e = Expression.constant(-1, Integer.TYPE);
                break;
            }
            case 3: {
                e = Expression.constant(0, Integer.TYPE);
                break;
            }
            case 4: {
                e = Expression.constant(1, Integer.TYPE);
                break;
            }
            case 5: {
                e = Expression.constant(2, Integer.TYPE);
                break;
            }
            case 6: {
                e = Expression.constant(3, Integer.TYPE);
                break;
            }
            case 7: {
                e = Expression.constant(4, Integer.TYPE);
                break;
            }
            case 8: {
                e = Expression.constant(5, Integer.TYPE);
                break;
            }
            case 9: {
                e = Expression.constant(0L, Long.TYPE);
                break;
            }
            case 10: {
                e = Expression.constant(1L, Long.TYPE);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.add(second, first);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.subtract(second, first);
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.multiply(second, first);
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.divide(second, first);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.modulo(second, first);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                Expression first = this._exprStack.pop();
                e = Expression.negate(first);
                break;
            }
            case 120: 
            case 121: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.leftShift(second, first);
                break;
            }
            case 122: 
            case 123: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.rightShift(second, first);
                break;
            }
            case 124: 
            case 125: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.rightShift(second, first);
                break;
            }
            case 126: 
            case 127: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.bitwiseAnd(second, first);
                break;
            }
            case 128: 
            case 129: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.bitwiseOr(second, first);
                break;
            }
            case 130: 
            case 131: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.exclusiveOr(second, first);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup2[opcode - 145]);
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 133 + 1]);
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                int l2l = opcode > 136 ? 1 : 0;
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 136 + l2l]);
                break;
            }
            case 139: 
            case 140: 
            case 141: {
                int f2f = opcode == 141 ? 1 : 0;
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 139 + f2f]);
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 142]);
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.go(null);
                return;
            }
            case 95: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                this._exprStack.push(first);
                this._exprStack.push(second);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                int base = (opcode - 89) % 3;
                ExpressionMethodVisitor.dup(this._exprStack, ++base, base - 1);
                return;
            }
            case 0: 
            case 177: {
                return;
            }
            case 87: 
            case 88: {
                if (this._statements == null) {
                    this._statements = new ArrayList<Expression>();
                }
                this._statements.add(this._exprStack.pop());
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Expression value = this._exprStack.pop();
                Expression index = this._exprStack.pop();
                Expression newArrayInit = this._exprStack.pop();
                if (!(index instanceof ConstantExpression) || !index.getResultType().equals(Integer.TYPE)) {
                    throw ExpressionMethodVisitor.notLambda(opcode);
                }
                if (!(newArrayInit instanceof NewArrayInitExpression)) {
                    throw ExpressionMethodVisitor.notLambda(opcode);
                }
                NewArrayInitExpression newArrayInitExpression = (NewArrayInitExpression)newArrayInit;
                newArrayInitExpression.getInitializers().set((Integer)((ConstantExpression)index).getValue(), value);
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
        this._exprStack.push(e);
    }

    private static void dup(ExpressionStack stack, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Expression e = (Expression)stack.get(stack.size() - fromIndex--);
        ExpressionMethodVisitor.dup(stack, fromIndex, toIndex);
        stack.push(e);
    }

    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 16: 
            case 17: {
                this._exprStack.push(Expression.constant(operand, Integer.TYPE));
                break;
            }
            case 188: {
                this._exprStack.push(this.createNewArrayInitExpression(opcode, arrayTypesByCode[operand - 4]));
                break;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        int etype;
        switch (opcode) {
            case 167: {
                this.go(label);
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
            case 153: {
                etype = 31;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 154: {
                etype = 10;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 155: {
                etype = 13;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 156: {
                etype = 20;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 157: {
                etype = 21;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 158: {
                etype = 12;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 159: 
            case 165: {
                etype = 31;
                break;
            }
            case 160: 
            case 166: {
                etype = 10;
                break;
            }
            case 161: {
                etype = 13;
                break;
            }
            case 162: {
                etype = 20;
                break;
            }
            case 163: {
                etype = 21;
                break;
            }
            case 164: {
                etype = 12;
                break;
            }
            case 198: 
            case 199: {
                Expression e = Expression.isNull(this._exprStack.pop());
                if (opcode == 198) {
                    e = Expression.logicalNot(e);
                }
                this.branch(label, e);
                return;
            }
        }
        Expression second = this._exprStack.pop();
        Expression first = this._exprStack.pop();
        Expression e = Expression.binary(etype, first, second);
        this.branch(label, e);
    }

    private static ExpressionStack reduce(ExpressionStack first, ExpressionStack second) {
        int sDepth;
        int fDepth = first.getDepth();
        if (fDepth == (sDepth = second.getDepth())) {
            ExpressionStack.BranchExpression secondBB;
            ExpressionStack.BranchExpression firstBB;
            ExpressionStack.BranchExpression secondB;
            ExpressionStack.BranchExpression firstB = first.getParent();
            if (firstB == (secondB = second.getParent())) {
                ExpressionStack parentStack = firstB.getParent();
                parentStack.pop();
                Expression right = firstB.getTrue().pop();
                Expression left = firstB.getFalse().pop();
                assert (ExpressionMethodVisitor.normalizePrimitive(right.getResultType()) == ExpressionMethodVisitor.normalizePrimitive(left.getResultType())) : "branches must evaluate to same type";
                parentStack.push(Expression.condition(firstB.getTest(), right, left));
                return parentStack;
            }
            if (first.size() == 0 && second.size() == 0 && (firstBB = firstB.getParent().getParent()) == (secondBB = secondB.getParent().getParent())) {
                ExpressionStack l;
                Expression fTest = firstB.getTest();
                if (firstB.getTrue() != first) {
                    fTest = Expression.logicalNot(fTest);
                    l = firstB.getTrue();
                } else {
                    l = firstB.getFalse();
                }
                Expression sTest = secondB.getTest();
                if (secondB.getTrue() != second) {
                    sTest = Expression.logicalNot(sTest);
                    secondB.getTrue().reduce();
                } else {
                    secondB.getFalse().reduce();
                }
                Expression rootTest = firstBB.getTest();
                if (firstBB.getTrue() != firstB.getParent()) {
                    rootTest = Expression.logicalNot(rootTest);
                }
                rootTest = Expression.condition(rootTest, fTest, sTest);
                ExpressionStack parentStack = firstBB.getParent();
                ExpressionStack.BranchExpression be = new ExpressionStack.BranchExpression(parentStack, rootTest, first, l);
                parentStack.pop();
                parentStack.add(be);
                return first;
            }
        } else if (first.size() == 0 && second.size() == 0) {
            ExpressionStack other;
            ExpressionStack younger;
            ExpressionStack older;
            if (fDepth > sDepth) {
                older = second;
                younger = first;
            } else {
                older = first;
                younger = second;
            }
            boolean trueB = older.getParent().getTrue() == older;
            ExpressionStack.BranchExpression youngerBranch = younger.getParent();
            Expression youngTest = youngerBranch.getTest();
            if (younger.getParent().get(trueB) != younger) {
                youngTest = Expression.logicalNot(youngTest);
                other = youngerBranch.get(trueB);
            } else {
                other = youngerBranch.get(!trueB);
            }
            Expression test = Expression.logicalAnd(older.getParent().getTest(), youngTest);
            if (!trueB) {
                test = Expression.logicalNot(test);
            }
            ExpressionStack parentStack = older.getParent().getParent();
            ExpressionStack.BranchExpression be = new ExpressionStack.BranchExpression(parentStack, test, older, other);
            parentStack.pop();
            parentStack.add(be);
            return older;
        }
        return null;
    }

    private static ExpressionStack reduce(List<ExpressionStack> bl) {
        int index = bl.size() - 1;
        ExpressionStack second = bl.remove(index--);
        if (index < 0) {
            return second;
        }
        ExpressionStack first = bl.get(index);
        ExpressionStack reduced = ExpressionMethodVisitor.reduce(first, second);
        if (reduced != null) {
            bl.set(index, reduced);
            return ExpressionMethodVisitor.reduce(bl);
        }
        first = ExpressionMethodVisitor.reduce(bl);
        return ExpressionMethodVisitor.reduce(first, second);
    }

    public void visitLabel(Label label) {
        List<ExpressionStack> bl = this._branches.remove(label);
        if (bl == null) {
            return;
        }
        for (int i = bl.size() - 1; i >= 0; --i) {
            ExpressionStack es = bl.get(i);
            if (!es.isReduced()) continue;
            bl.remove(i);
        }
        if (this._exprStack != null) {
            bl.add(this._exprStack);
        }
        this._exprStack = ExpressionMethodVisitor.reduce(bl);
        assert (this._exprStack != null);
    }

    public void visitLdcInsn(Object cst) {
        Class<Object> type = _primitives.get(cst.getClass());
        if (type == null && (type = cst.getClass()) == Type.class) {
            type = Class.class;
            cst = this._classVisitor.getClass((Type)cst);
        }
        this._exprStack.push(Expression.constant(cst, type));
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        throw ExpressionMethodVisitor.notLambda(-1);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        throw ExpressionMethodVisitor.notLambda(171);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this._localVariables != null) {
            if (this._me != null) {
                --maxLocals;
            }
            maxLocals = this.compensate2SlotsValues(maxLocals);
            this._localVariables = Arrays.copyOf(this._localVariables, maxLocals -= this._argTypes.length);
        }
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        String bootMethod = bootstrapMethodHandle.getName();
        if (!bootstrapMethodHandle.getOwner().equals(LambdaMetafactoryClassInternalName) || !"Metafactory".regionMatches(true, 0, bootMethod, bootMethod.length() - "Metafactory".length(), "Metafactory".length())) {
            throw new UnsupportedOperationException("Unsupported bootstrapMethodHandle: " + bootstrapMethodHandle);
        }
        Handle handle = (Handle)bootstrapMethodArguments[1];
        Type objectType = Type.getObjectType((String)handle.getOwner());
        Type[] argsTypes = Type.getArgumentTypes((String)descriptor);
        Expression[] arguments = this.createArguments(argsTypes);
        boolean hasThis = handle.getTag() == 9 || handle.getTag() == 7 || handle.getTag() == 5;
        Expression optionalThis = hasThis && arguments.length > 0 ? arguments[0] : null;
        LambdaExpression<?> lambda = ExpressionClassCracker.get().lambdaFromClassLoader(this._classVisitor.getLoader(), objectType.getInternalName(), optionalThis, handle.getName(), handle.getDesc());
        if (optionalThis instanceof ConstantExpression) {
            arguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            argsTypes = Arrays.copyOfRange(argsTypes, 1, argsTypes.length);
        }
        if (argsTypes.length == 0) {
            this._exprStack.push(lambda);
            return;
        }
        Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
        this.convertArguments(arguments, parameterTypes);
        ArrayList<ParameterExpression> params = new ArrayList<ParameterExpression>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            params.add(Expression.parameter(parameterTypes[i], i));
        }
        LambdaExpression<?> partial = Expression.lambda(lambda.getResultType(), lambda, params, Collections.emptyList(), null);
        InvocationExpression e = Expression.invoke(partial, arguments);
        this._exprStack.push(e);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        Expression e;
        Type[] argsTypes = Type.getArgumentTypes((String)desc);
        Expression[] arguments = this.createArguments(argsTypes);
        switch (opcode) {
            case 183: {
                if (name.equals("<init>")) {
                    Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                    this.convertArguments(arguments, parameterTypes);
                    try {
                        e = Expression.newInstance(this._exprStack.pop().getResultType(), parameterTypes, arguments);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                    this._exprStack.pop();
                    break;
                }
            }
            case 182: 
            case 185: {
                try {
                    Class<?> lambdaClass = this._classVisitor.getClass(Type.getObjectType((String)owner));
                    Expression instance = this._exprStack.pop();
                    if (instance.getExpressionType() == 7) {
                        Object value = ((ConstantExpression)instance).getValue();
                        if (value instanceof SerializedLambda) {
                            Class<?> serializedClass;
                            SerializedLambda serialized = (SerializedLambda)value;
                            ClassLoader lambdaClassLoader = this._classVisitor.getLoader();
                            try {
                                serializedClass = lambdaClassLoader.loadClass(serialized.getFunctionalInterfaceClass().replace('/', '.'));
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new RuntimeException(cnfe);
                            }
                            if (!lambdaClass.isAssignableFrom(serializedClass)) {
                                throw new ClassCastException(serializedClass + " cannot be cast to " + lambdaClass);
                            }
                            if (!serialized.getFunctionalInterfaceMethodName().equals(name)) {
                                throw new NoSuchMethodException(name);
                            }
                            LambdaExpression<?> lambda = ExpressionClassCracker.get().lambda(serialized, lambdaClassLoader);
                            Class[] parameterTypes = (Class[])lambda.getParameters().stream().map(Expression::getResultType).toArray(Class[]::new);
                            this.convertArguments(arguments, parameterTypes);
                            e = Expression.invoke(lambda, arguments);
                            break;
                        }
                        Class<?> instanceClass = value.getClass();
                        if (instanceClass.isSynthetic()) {
                            LambdaExpression<?> inst = value instanceof Serializable ? ExpressionClassCracker.get().lambda(value, true) : ExpressionClassCracker.get().lambdaFromFileSystem(value, instance.getResultType().getDeclaredMethod(name, this.getParameterTypes(argsTypes)), null);
                            e = Expression.invoke(inst, arguments);
                            break;
                        }
                    }
                    Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                    this.convertArguments(arguments, parameterTypes);
                    e = Expression.invoke(TypeConverter.convert(instance, lambdaClass), name, parameterTypes, arguments);
                    break;
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException(nsme);
                }
            }
            case 184: {
                Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                this.convertArguments(arguments, parameterTypes);
                try {
                    Class<?> targetType = this._classVisitor.getClass(Type.getObjectType((String)owner));
                    if (targetType.isSynthetic()) {
                        LambdaExpression<?> lambda = ExpressionClassCracker.get().lambdaFromFileSystem(null, targetType.getDeclaredMethod(name, this.getParameterTypes(argsTypes)), this._classVisitor.getLoader());
                        e = Expression.invoke(lambda, arguments);
                        break;
                    }
                    e = Expression.invoke(targetType, name, parameterTypes, arguments);
                    break;
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException(nsme);
                }
            }
            default: {
                throw new IllegalArgumentException("opcode: " + opcode);
            }
        }
        this._exprStack.push(e);
    }

    private void convertArguments(Expression[] arguments, Class<?>[] parameterTypes) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = TypeConverter.convert(arguments[i], parameterTypes[i]);
        }
    }

    private Expression[] createArguments(Type[] argsTypes) {
        Expression[] arguments = new Expression[argsTypes.length];
        int i = argsTypes.length;
        while (i > 0) {
            arguments[--i] = this._exprStack.pop();
        }
        return arguments;
    }

    private Class<?>[] getParameterTypes(Type[] argsTypes) {
        Class[] parameterTypes = new Class[argsTypes.length];
        for (int i = 0; i < argsTypes.length; ++i) {
            parameterTypes[i] = this._classVisitor.getClass(argsTypes[i]);
        }
        return parameterTypes;
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        throw ExpressionMethodVisitor.notLambda(197);
    }

    public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
        return null;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        throw ExpressionMethodVisitor.notLambda(170);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        throw ExpressionMethodVisitor.notLambda(-2);
    }

    public void visitTypeInsn(int opcode, String type) {
        Expression e;
        Class<?> resultType = this._classVisitor.getClass(Type.getObjectType((String)type));
        switch (opcode) {
            case 187: {
                e = Expression.constant(null, resultType);
                break;
            }
            case 192: {
                if (resultType == Object.class) {
                    return;
                }
                e = Expression.convert(this._exprStack.pop(), resultType);
                break;
            }
            case 189: {
                e = this.createNewArrayInitExpression(opcode, resultType);
                break;
            }
            case 193: {
                e = Expression.instanceOf(this._exprStack.pop(), resultType);
                break;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
        this._exprStack.push(e);
    }

    private Expression createNewArrayInitExpression(int opcode, Class<?> componentType) {
        Expression count = this._exprStack.pop();
        if (!(count instanceof ConstantExpression) || !count.getResultType().equals(Integer.TYPE)) {
            throw ExpressionMethodVisitor.notLambda(opcode);
        }
        return new NewArrayInitExpression(componentType, (Integer)((ConstantExpression)count).getValue());
    }

    public void visitVarInsn(int opcode, int var) {
        Class<Number> type;
        if (this._me != null) {
            if (var == 0) {
                this._exprStack.push(this._me);
                return;
            }
            --var;
        }
        var = this.compensate2SlotsValues(var);
        switch (opcode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (this._localVariables == null) {
                    this._localVariables = new Expression[10];
                }
                if ((var -= this._argTypes.length) < 0) {
                    throw new IllegalArgumentException("Parameter cannot be reassigned. Use local variables.");
                }
                if (var >= this._localVariables.length) {
                    this._localVariables = Arrays.copyOf(this._localVariables, var >> 1);
                } else if (this._localVariables[var] != null) {
                    throw new IllegalArgumentException("Local variable must be final or effectively final.");
                }
                this._localVariables[var] = this._exprStack.pop();
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
            case 21: {
                type = Integer.TYPE;
                break;
            }
            case 22: {
                type = Long.TYPE;
                break;
            }
            case 23: {
                type = Float.TYPE;
                break;
            }
            case 24: {
                type = Double.TYPE;
                break;
            }
            case 25: {
                if (var < this._argTypes.length) {
                    type = this._argTypes[var];
                    break;
                }
                int localVar = var - this._argTypes.length;
                type = this._localVariables[localVar].getResultType();
            }
        }
        this._exprStack.push(Expression.parameter(type, var));
    }

    private int compensate2SlotsValues(int var) {
        for (int i = 0; i < var && i < this._argTypes.length; ++i) {
            Class<?> clazz = this._argTypes[i];
            if (clazz != Long.TYPE && clazz != Double.TYPE) continue;
            --var;
        }
        return var;
    }

    static RuntimeException notLambda(int opcode) {
        String opcodeName = Integer.toString(opcode);
        Field[] ops = Opcodes.class.getFields();
        for (int i = 0; i < ops.length; ++i) {
            Field f = ops[i];
            if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE) continue;
            try {
                int test = f.getInt(null);
                if (test != opcode) continue;
                opcodeName = f.getName();
            }
            catch (IllegalAccessException e) {}
            break;
        }
        return new IllegalArgumentException("Not a lambda expression. Opcode " + opcodeName + " is illegal.");
    }

    static {
        arrayTypesByCode = new Class[]{Boolean.TYPE, Character.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE};
        HashMap primitives = new HashMap(8);
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Double.class, Double.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Short.class, Short.TYPE);
        _primitives = primitives;
    }
}

