/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class ExpressionStack
extends ArrayList<Expression> {
    private BranchExpression _parent;
    private boolean _reduced;
    private final List<Expression> ordered = new ArrayList<Expression>(64);
    private static final Expression[] EmptyExpressionArray = new Expression[0];

    @Override
    void sort(List<Expression> expressions) {
        int i;
        Expression[] copy = expressions.toArray(EmptyExpressionArray);
        int[] indices = new int[copy.length];
        Integer[] orders = new Integer[copy.length];
        for (i = 0; i < copy.length; ++i) {
            orders[i] = i;
            indices[i] = this.ordered.lastIndexOf(copy[i]);
        }
        Arrays.sort(orders, (i1, i2) -> indices[i1] - indices[i2]);
        for (i = 0; i < copy.length; ++i) {
            expressions.set(i, copy[orders[i]]);
        }
    }

    ExpressionStack() {
        this((BranchExpression)null);
    }

    ExpressionStack(BranchExpression parent) {
        this._parent = parent;
    }

    BranchExpression getParent() {
        return this._parent;
    }

    private void setParent(BranchExpression value) {
        this._parent = value;
    }

    boolean isReduced() {
        return this._reduced;
    }

    void reduce() {
        this._reduced = true;
    }

    void push(Expression item) {
        this.add(item);
        this.ordered.add(item);
    }

    int getDepth() {
        return this.getParent() != null ? this.getParent().getDepth() : 0;
    }

    Expression pop() {
        Expression obj = this.peek();
        this.remove(this.size() - 1);
        return obj;
    }

    Expression peek() {
        Expression obj = (Expression)this.get(this.size() - 1);
        return obj;
    }

    static final class BranchExpression
    extends Expression {
        private final Expression _test;
        private final ExpressionStack _true;
        private final ExpressionStack _false;
        private final ExpressionStack _parent;

        BranchExpression(ExpressionStack parent, Expression test) {
            this(parent, test, null, null);
        }

        BranchExpression(ExpressionStack parent, Expression test, ExpressionStack trueE, ExpressionStack falseE) {
            super(6, Void.TYPE);
            this._parent = parent;
            this._test = test;
            if (trueE != null) {
                this._true = trueE;
                this._true.setParent(this);
            } else {
                this._true = new ExpressionStack(this);
            }
            if (falseE != null) {
                this._false = falseE;
                this._false.setParent(this);
            } else {
                this._false = new ExpressionStack(this);
            }
        }

        ExpressionStack getTrue() {
            return this._true;
        }

        ExpressionStack getFalse() {
            return this._false;
        }

        ExpressionStack get(boolean side) {
            return side ? this.getTrue() : this.getFalse();
        }

        Expression getTest() {
            return this._test;
        }

        ExpressionStack getParent() {
            return this._parent;
        }

        int getDepth() {
            return this._parent.getDepth() + 1;
        }

        @Override
        protected <T> T visit(ExpressionVisitor<T> v) {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getTest().toString() + " ? " + this.getTrue().toString() + " : " + this.getFalse().toString() + ")";
        }
    }
}

