/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import co.streamx.fluent.extree.expression.InvocableExpression;
import co.streamx.fluent.extree.expression.LambdaExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.TypeConverter;
import java.util.List;

public final class InvocationExpression
extends Expression {
    private final InvocableExpression target;
    private final List<Expression> arguments;

    InvocationExpression(InvocableExpression method, List<Expression> arguments) {
        super(14, method.getResultType());
        List<ParameterExpression> pp = method.getParameters();
        for (int i = 0; i < pp.size(); ++i) {
            Class<?> paramType;
            Class<?> resultType = arguments.get(i).getResultType();
            if (resultType == Object.class || TypeConverter.isAssignable(paramType = pp.get(i).getResultType(), resultType) || paramType.isInterface() && resultType == LambdaExpression.class) continue;
            throw new IllegalArgumentException(String.valueOf(i));
        }
        this.target = method;
        this.arguments = arguments;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        InvocableExpression normalized = this.getTarget();
        b.append(normalized.toString());
        if (normalized.getExpressionType() != 22) {
            b.append('(');
            List<ParameterExpression> parameters = normalized.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                b.append(this.arguments.get(parameters.get(i).getIndex()).toString());
            }
            b.append(')');
        }
        return b.toString();
    }

    public InvocableExpression getTarget() {
        return this.target;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }
}

