/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionClassCracker;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import co.streamx.fluent.extree.expression.Interpreter;
import co.streamx.fluent.extree.expression.InvocableExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.TypeConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;

public final class LambdaExpression<F>
extends InvocableExpression {
    private final Expression body;
    private final List<Expression> locals;
    private final Object key;

    LambdaExpression(Class<?> resultType, @NonNull Expression body, List<ParameterExpression> params, @NonNull List<Expression> locals, Object key) {
        super(17, resultType, params);
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (locals == null) {
            throw new NullPointerException("locals is marked non-null but is null");
        }
        if (!TypeConverter.isAssignable(resultType, body.getResultType())) {
            throw new IllegalArgumentException(body.getResultType() + " is not assignable to " + resultType);
        }
        this.body = body;
        this.locals = locals;
        this.key = key;
    }

    public static <T> LambdaExpression<T> parse(T lambda) {
        LambdaExpression<?> lambdaE = ExpressionClassCracker.get().lambda(lambda, true);
        return lambdaE;
    }

    public static <T> LambdaExpression<T> parseMethod(T methodReference) {
        return ExpressionClassCracker.get().lambda(methodReference, false);
    }

    public static LambdaExpression<?> parseMethod(Method method, Object instance) {
        if (Modifier.isStatic(method.getModifiers()) ^ instance == null) {
            throw new IllegalArgumentException("Instance does not suit the method: " + method);
        }
        return ExpressionClassCracker.get().lambdaFromFileSystem(instance, method, method.getDeclaringClass().getClassLoader());
    }

    public static Function<Object[], ?> compile(Expression e) {
        return (Function)e.accept(Interpreter.Instance);
    }

    public Function<Object[], ?> compile() {
        Function f = (Function)this.accept(Interpreter.Instance);
        return pp -> {
            Function f1 = (Function)f.apply(pp);
            return f1.apply(null);
        };
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        boolean hasLocals;
        StringBuilder b = new StringBuilder();
        b.append('{');
        List<ParameterExpression> arguments = this.getParameters();
        if (arguments.size() > 0) {
            b.append('(');
            for (int i = 0; i < arguments.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                ParameterExpression pe = arguments.get(i);
                b.append(pe.getResultType().getName());
                b.append(' ');
                b.append(pe.toString());
            }
            b.append(')');
        }
        b.append(" -> ");
        boolean bl = hasLocals = !this.locals.isEmpty();
        if (hasLocals) {
            b.append("{\n");
            for (int i = 0; i < this.locals.size(); ++i) {
                Expression e = this.locals.get(i);
                if (e == null) continue;
                b.append("LOCAL[");
                b.append(i + arguments.size());
                b.append("] = ");
                b.append(e);
                b.append('\n');
            }
            if (this.getResultType() != Void.TYPE) {
                b.append("return ");
            }
        }
        b.append(this.getBody().toString());
        if (hasLocals) {
            b.append("\n}");
        }
        b.append('}');
        return b.toString();
    }

    public Expression getBody() {
        return this.body;
    }

    public List<Expression> getLocals() {
        return this.locals;
    }

    public Object getKey() {
        return this.key;
    }
}

