/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class NewArrayInitExpression
extends Expression {
    private final Class<?> componentType;
    private final List<Expression> initializers;

    NewArrayInitExpression(@NonNull Class<?> type, int count) {
        this(type, Arrays.asList(new Expression[count]));
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    NewArrayInitExpression(@NonNull Class<?> type, @NonNull List<Expression> initializers) {
        super(28, Array.newInstance(type, 0).getClass());
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (initializers == null) {
            throw new NullPointerException("initializers is marked non-null but is null");
        }
        this.componentType = type;
        this.initializers = initializers;
    }

    public int getCount() {
        return this.initializers.size();
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append(this.initializers.stream().map(Object::toString).collect(Collectors.joining(",")));
        b.append('}');
        return b.toString();
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public List<Expression> getInitializers() {
        return this.initializers;
    }
}

