/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.BinaryExpression;
import co.streamx.fluent.extree.expression.BlockExpression;
import co.streamx.fluent.extree.expression.ConstantExpression;
import co.streamx.fluent.extree.expression.DelegateExpression;
import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import co.streamx.fluent.extree.expression.InvocableExpression;
import co.streamx.fluent.extree.expression.InvocationExpression;
import co.streamx.fluent.extree.expression.LambdaExpression;
import co.streamx.fluent.extree.expression.MemberExpression;
import co.streamx.fluent.extree.expression.NewArrayInitExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.UnaryExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class SimpleExpressionVisitor
implements ExpressionVisitor<Expression> {
    private final List<List<Expression>> argumentsStack = new ArrayList<List<Expression>>();

    protected List<Expression> getContextArguments() {
        return this.argumentsStack.isEmpty() ? null : this.argumentsStack.get(this.argumentsStack.size() - 1);
    }

    protected List<Expression> popContextArguments() {
        return this.argumentsStack.isEmpty() ? null : this.argumentsStack.remove(this.argumentsStack.size() - 1);
    }

    protected Expression resolveContextParameter(ParameterExpression p) {
        return this.resolveContextParameter(p, this.argumentsStack.size() - 1);
    }

    private Expression resolveContextParameter(ParameterExpression p, int frame) {
        Expression e = this.argumentsStack.get(frame).get(p.getIndex());
        if (e instanceof ParameterExpression) {
            return frame == 0 ? e : this.resolveContextParameter((ParameterExpression)e, frame - 1);
        }
        return e;
    }

    protected void pushContextArguments(List<Expression> args) {
        this.argumentsStack.add(args);
    }

    protected <T extends Expression> List<T> visitExpressionList(List<T> original) {
        if (original != null) {
            ArrayList<Expression> list = null;
            int n = original.size();
            for (int i = 0; i < n; ++i) {
                Expression p;
                Expression t = (Expression)original.get(i);
                Expression expression = p = t != null ? t.accept(this) : t;
                if (list != null) {
                    list.add(p);
                    continue;
                }
                if (p == original.get(i)) continue;
                list = new ArrayList<Expression>(n);
                for (int j = 0; j < i; ++j) {
                    list.add((Expression)original.get(j));
                }
                list.add(p);
            }
            if (list != null) {
                return Collections.unmodifiableList(list);
            }
        }
        return original;
    }

    protected List<Expression> visitLocals(List<Expression> original) {
        return this.visitExpressionList(original);
    }

    protected List<Expression> visitArguments(List<Expression> original) {
        return this.visitExpressionList(original);
    }

    protected List<ParameterExpression> visitParameters(List<ParameterExpression> original) {
        return this.visitExpressionList(original);
    }

    @Override
    public Expression visit(BinaryExpression e) {
        Expression visitedOp;
        Expression first = e.getFirst();
        Expression visitedFirst = first.accept(this);
        Expression second = e.getSecond();
        Expression visitedSecond = second.accept(this);
        Expression op = e.getOperator();
        Expression expression = visitedOp = op != null ? op.accept(this) : op;
        if (first != visitedFirst || second != visitedSecond || op != visitedOp) {
            return Expression.binary(e.getExpressionType(), visitedOp, visitedFirst, visitedSecond);
        }
        return e;
    }

    @Override
    public Expression visit(ConstantExpression e) {
        Expression newValue;
        Object value = e.getValue();
        if (value instanceof Expression && value != (newValue = ((Expression)value).accept(this))) {
            return Expression.constant(newValue);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visit(InvocationExpression e) {
        List<Expression> arguments = e.getArguments();
        Expression target = e.getTarget();
        boolean visitTargetWithOldArgs = target.getExpressionType() == 18;
        boolean cleanArgsStack = false;
        List<Expression> args = arguments;
        if (!visitTargetWithOldArgs) {
            args = this.visitArguments(arguments);
            this.pushContextArguments(arguments);
            cleanArgsStack = true;
        }
        try {
            target = target.accept(this);
            if (visitTargetWithOldArgs) {
                args = this.visitArguments(arguments);
            }
            if (args != arguments || target != e.getTarget()) {
                Expression expression = this.invoke((InvocableExpression)target, args, e);
                return expression;
            }
            InvocationExpression invocationExpression = e;
            return invocationExpression;
        }
        finally {
            if (cleanArgsStack) {
                this.popContextArguments();
            }
        }
    }

    protected Expression invoke(InvocableExpression target, List<Expression> args, InvocationExpression original) {
        return Expression.invoke(target, args);
    }

    @Override
    public Expression visit(LambdaExpression<?> e) {
        List<ParameterExpression> parameters = this.visitParameters(e.getParameters());
        List<Expression> locals = this.visitLocals(e.getLocals());
        Expression body = e.getBody().accept(this);
        if (body != e.getBody() || parameters != e.getParameters() || locals != e.getLocals()) {
            return Expression.lambda(e.getResultType(), body, parameters, locals, e.getKey());
        }
        return e;
    }

    @Override
    public Expression visit(DelegateExpression e) {
        List<ParameterExpression> parameters = this.visitParameters(e.getParameters());
        if (parameters != e.getParameters()) {
            return Expression.delegate(e.getResultType(), e.getDelegate(), parameters);
        }
        return e;
    }

    @Override
    public Expression visit(BlockExpression e) {
        List<Expression> expressions = e.getExpressions();
        ArrayList<Expression> visitedList = new ArrayList<Expression>(expressions.size());
        boolean changed = false;
        for (Expression s : expressions) {
            Expression visited;
            if (s != (visited = s.accept(this))) {
                changed = true;
            }
            visitedList.add(visited);
        }
        return changed ? Expression.block(e.getResultType(), visitedList) : e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visit(MemberExpression e) {
        Expression instance = e.getInstance();
        if (instance != null) {
            List<Expression> contextArguments = this.popContextArguments();
            try {
                instance = instance.accept(this);
            }
            finally {
                if (contextArguments != null) {
                    this.pushContextArguments(contextArguments);
                }
            }
            if (instance instanceof LambdaExpression) {
                return instance;
            }
        }
        List<ParameterExpression> parameters = this.visitParameters(e.getParameters());
        if (instance != e.getInstance() || parameters != e.getParameters()) {
            return Expression.member(e.getExpressionType(), instance, e.getMember(), e.getResultType(), parameters);
        }
        return e;
    }

    @Override
    public Expression visit(NewArrayInitExpression newArrayInitExpression) {
        Expression[] initializers = newArrayInitExpression.getInitializers().toArray(new Expression[0]);
        boolean changed = false;
        for (int i = 0; i < initializers.length; ++i) {
            Expression e = initializers[i];
            Expression visited = e.accept(this);
            if (e == visited) continue;
            changed = true;
            initializers[i] = visited;
        }
        return changed ? Expression.newArrayInit(newArrayInitExpression.getComponentType(), Arrays.asList(initializers)) : newArrayInitExpression;
    }

    @Override
    public Expression visit(ParameterExpression e) {
        return e;
    }

    @Override
    public Expression visit(UnaryExpression e) {
        Expression visitedOp;
        Expression operand = e.getFirst();
        if (operand != (visitedOp = operand.accept(this))) {
            return Expression.unary(e.getExpressionType(), e.getResultType(), visitedOp);
        }
        return e;
    }
}

