/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.BinaryExpression;
import co.streamx.fluent.extree.expression.ConstantExpression;
import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.InvocationExpression;
import co.streamx.fluent.extree.expression.LambdaExpression;
import co.streamx.fluent.extree.expression.MemberExpression;
import co.streamx.fluent.extree.expression.ParameterExpression;
import co.streamx.fluent.extree.expression.SimpleExpressionVisitor;
import co.streamx.fluent.extree.expression.UnaryExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TypeConverter
extends SimpleExpressionVisitor {
    private final Class<?> _to;
    private static final Map<Class<?>, List<Class<?>>> primitiveWides;
    private static final Class<?>[] wrappers;

    private static <T> Class<T> wrap(Class<T> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        String name = clazz.getName();
        char c0 = name.charAt(0);
        char c2 = name.charAt(2);
        int mapper = c0 + c0 + c0 + 5 & 118 - c2;
        return wrappers[mapper];
    }

    private TypeConverter(Class<?> to) {
        this._to = to;
    }

    static Expression convert(Expression e, Class<?> to) {
        if (e == null) {
            return Expression.block(to, Collections.emptyList());
        }
        Class<?> from = e.getResultType();
        if (to.isAssignableFrom(from)) {
            return e;
        }
        return e.accept(new TypeConverter(to));
    }

    private Object convert(Class<?> from, Object value) {
        if (from == Integer.TYPE) {
            return this.convert((Integer)value);
        }
        return this.defaultConvert(value);
    }

    private Object convert(int value) {
        if (this._to == Boolean.TYPE) {
            if (value == 0) {
                return Boolean.FALSE;
            }
            if (value == 1) {
                return Boolean.TRUE;
            }
        } else if (this._to == Character.TYPE) {
            return Character.valueOf((char)value);
        }
        return this.defaultConvert(value);
    }

    private Expression defaultConvert(Expression e) {
        if (TypeConverter.isAssignable(this._to, e.getResultType())) {
            return e;
        }
        return Expression.convert(e, this._to);
    }

    private Object defaultConvert(Object value) {
        return this._to.cast(value);
    }

    @Override
    public Expression visit(BinaryExpression e) {
        if (TypeConverter.isAssignable(this._to, e.getResultType())) {
            return e;
        }
        Expression first = e.getFirst().accept(this);
        Expression second = e.getSecond().accept(this);
        Expression op = e.getOperator();
        return Expression.condition(op, first, second);
    }

    @Override
    public Expression visit(ConstantExpression e) {
        Class<?> resultType = e.getResultType();
        if (TypeConverter.isAssignable(this._to, resultType)) {
            return e;
        }
        return Expression.constant(this.convert(resultType, e.getValue()), this._to);
    }

    @Override
    public Expression visit(InvocationExpression e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(LambdaExpression<?> e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(MemberExpression e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(ParameterExpression e) {
        if (TypeConverter.isAssignable(e.getResultType(), this._to)) {
            return Expression.parameter(this._to, e.getIndex());
        }
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(UnaryExpression e) {
        return this.defaultConvert(e);
    }

    public static boolean isAssignable(Class<?> to, Class<?> from) {
        if ((to = TypeConverter.wrap(to)).isAssignableFrom(from = TypeConverter.wrap(from))) {
            return true;
        }
        List<Class<?>> wides = primitiveWides.get(from);
        return wides != null && wides.contains(to);
    }

    static {
        HashMap wides = new HashMap();
        wides.put(Byte.class, Arrays.asList(Short.class, Integer.class, Long.class, Float.class, Double.class));
        wides.put(Short.class, Arrays.asList(Integer.class, Long.class, Float.class, Double.class));
        wides.put(Character.class, Arrays.asList(String.class, CharSequence.class));
        wides.put(Integer.class, Arrays.asList(Long.class, Float.class, Double.class));
        wides.put(Long.class, Arrays.asList(Float.class, Double.class));
        wides.put(Float.class, Arrays.asList(Double.class));
        primitiveWides = wides;
        wrappers = new Class[]{Integer.class, Double.class, Byte.class, Boolean.class, Character.class, Void.class, Short.class, Float.class, Long.class};
    }
}

