/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.expression;

import co.streamx.fluent.extree.expression.Expression;
import co.streamx.fluent.extree.expression.ExpressionType;
import co.streamx.fluent.extree.expression.ExpressionVisitor;
import lombok.NonNull;

public class UnaryExpression
extends Expression {
    private final Expression first;

    UnaryExpression(int expressionType, Class<?> resultType, @NonNull Expression operand) {
        super(expressionType, resultType);
        if (operand == null) {
            throw new NullPointerException("operand is marked non-null but is null");
        }
        this.first = operand;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExpressionType() == 8) {
            b.append('(');
            b.append(this.getResultType().getName());
            b.append(')');
        } else {
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(this.getFirst().toString());
        return b.toString();
    }

    public Expression getFirst() {
        return this.first;
    }
}

